/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.xml;

import com.easycodebox.common.lang.DataConvert;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.modelmbean.XMLParseException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XmlDataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlDataParser.class);
    public static final String COMMENT_ELEMENT = "comment";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_TYPE_ATTRIBUTE = "value-type";
    public static final String KEY_TYPE_ATTRIBUTE = "key-type";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final Map<String, Class<?>> classPool = new HashMap();

    public static Object parseDataElement(Element ele) throws XMLParseException {
        List el = ele.elements();
        Element subElement = null;
        for (int i = 0; i < el.size(); ++i) {
            Element e = (Element)el.get(i);
            if (COMMENT_ELEMENT.equals(e.getName())) continue;
            if (subElement != null) {
                throw new XMLParseException(ele.getName() + " must not contain more than one sub-element");
            }
            subElement = e;
        }
        Attribute valueAttr = ele.attribute("value");
        if (valueAttr != null && subElement != null) {
            throw new XMLParseException(ele.getName() + " is only allowed to contain either 'value' attribute OR sub-element");
        }
        if (valueAttr != null) {
            String typeClassName = ele.attributeValue(TYPE_ATTRIBUTE);
            String value = ele.attributeValue("value");
            try {
                return XmlDataParser.buildTypedStringValue(value, typeClassName, ele);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Type class [" + typeClassName + "] not found for value " + value), e);
                return value;
            }
        }
        if (subElement != null) {
            return XmlDataParser.parseDataSubElement(subElement);
        }
        throw new XMLParseException(ele.getName() + " must specify a value");
    }

    public static Object parseDataSubElement(Element ele) throws XMLParseException {
        return XmlDataParser.parseDataSubElement(ele, null);
    }

    public static Object parseDataSubElement(Element ele, String defaultTypeClassName) throws XMLParseException {
        if ("value".equals(ele.getName())) {
            return XmlDataParser.parseValueElement(ele, defaultTypeClassName);
        }
        if (NULL_ELEMENT.equals(ele.getName())) {
            return null;
        }
        if (LIST_ELEMENT.equals(ele.getName())) {
            return XmlDataParser.parseListElement(ele);
        }
        if (SET_ELEMENT.equals(ele.getName())) {
            return XmlDataParser.parseSetElement(ele);
        }
        if (MAP_ELEMENT.equals(ele.getName())) {
            return XmlDataParser.parseMapElement(ele);
        }
        if (PROPS_ELEMENT.equals(ele.getName())) {
            return XmlDataParser.parsePropsElement(ele);
        }
        throw new XMLParseException("Unknown property sub-element: [" + ele.getName() + "]");
    }

    public static Object parseValueElement(Element ele, String defaultTypeClassName) throws XMLParseException {
        String value = ele.getTextTrim();
        String typeClassName = ele.attributeValue(TYPE_ATTRIBUTE);
        if (StringUtils.isBlank((String)typeClassName)) {
            typeClassName = defaultTypeClassName;
        }
        try {
            return XmlDataParser.buildTypedStringValue(value, typeClassName, ele);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error((Object)("Type class [" + typeClassName + "] not found for <value> element"), ex);
            return value;
        }
    }

    protected static Object buildTypedStringValue(String value, String targetTypeName, Element ele) throws ClassNotFoundException, XMLParseException {
        if (StringUtils.isNotBlank((String)targetTypeName)) {
            Class<?> clazz = classPool.get(targetTypeName);
            if (clazz == null) {
                clazz = Class.forName(targetTypeName);
            }
            if (clazz != null) {
                return DataConvert.convertType(value, clazz);
            }
        }
        return value;
    }

    public static List parseListElement(Element collectionEle) throws XMLParseException {
        String defaultTypeClassName = collectionEle.attributeValue(VALUE_TYPE_ATTRIBUTE);
        List el = collectionEle.elements();
        ArrayList<Object> values = new ArrayList<Object>(el.size());
        for (int i = 0; i < el.size(); ++i) {
            Element e = (Element)el.get(i);
            if (COMMENT_ELEMENT.equals(e.getName())) continue;
            values.add(XmlDataParser.parseDataSubElement(e, defaultTypeClassName));
        }
        return values;
    }

    public static Set parseSetElement(Element collectionEle) throws XMLParseException {
        String defaultTypeClassName = collectionEle.attributeValue(VALUE_TYPE_ATTRIBUTE);
        List el = collectionEle.elements();
        HashSet<Object> set = new HashSet<Object>(el.size());
        for (int i = 0; i < el.size(); ++i) {
            Element e = (Element)el.get(i);
            if (COMMENT_ELEMENT.equals(e.getName())) continue;
            set.add(XmlDataParser.parseDataSubElement(e, defaultTypeClassName));
        }
        return set;
    }

    public static Map parseMapElement(Element mapEle) throws XMLParseException {
        String defaultKeyTypeClassName = mapEle.attributeValue(KEY_TYPE_ATTRIBUTE);
        String defaultValueTypeClassName = mapEle.attributeValue(VALUE_TYPE_ATTRIBUTE);
        List entryEles = mapEle.elements(ENTRY_ELEMENT);
        HashMap<Object, Object> map = new HashMap<Object, Object>(entryEles.size());
        for (Element entryEle : entryEles) {
            List el = entryEle.elements();
            Element keyEle = null;
            Element valueEle = null;
            for (int j = 0; j < el.size(); ++j) {
                Element candidateEle = (Element)el.get(j);
                if ("key".equals(candidateEle.getName())) {
                    if (keyEle != null) {
                        throw new XMLParseException(entryEle.attributeValue(NAME_ATTRIBUTE) + "<entry> element is only allowed to contain one <key> sub-element");
                    }
                    keyEle = candidateEle;
                    continue;
                }
                if (valueEle != null) {
                    throw new XMLParseException(entryEle.attributeValue(NAME_ATTRIBUTE) + "<entry> element must not contain more than one value sub-element");
                }
                valueEle = candidateEle;
            }
            Object key = null;
            Attribute keyAttribute = entryEle.attribute("key");
            if (keyAttribute != null && keyEle != null) {
                throw new XMLParseException(entryEle + "<entry> element is only allowed to contain either a 'key' attribute OR a <key> sub-element");
            }
            if (keyAttribute != null) {
                key = XmlDataParser.buildTypedStringValueForMap(entryEle.attributeValue("key"), defaultKeyTypeClassName, entryEle);
            } else if (keyEle != null) {
                key = XmlDataParser.parseKeyElement(keyEle, defaultKeyTypeClassName);
            } else {
                throw new XMLParseException("<entry> element must specify a key" + entryEle);
            }
            Object value = null;
            Attribute valueAttribute = entryEle.attribute("value");
            if (valueAttribute != null && valueEle != null) {
                throw new XMLParseException("<entry> element is only allowed to contain either 'value' attribute OR <value> sub-element" + entryEle);
            }
            if (valueAttribute != null) {
                value = XmlDataParser.buildTypedStringValueForMap(entryEle.attributeValue("value"), defaultValueTypeClassName, entryEle);
            } else if (valueEle != null) {
                value = XmlDataParser.parseDataSubElement(valueEle, defaultValueTypeClassName);
            } else {
                throw new XMLParseException("<entry> element must specify a value" + entryEle);
            }
            map.put(key, value);
        }
        return map;
    }

    protected static final Object buildTypedStringValueForMap(String value, String defaultTypeClassName, Element entryEle) throws XMLParseException {
        try {
            return XmlDataParser.buildTypedStringValue(value, defaultTypeClassName, entryEle);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error((Object)("Type class [" + defaultTypeClassName + "] not found for Map key/value type" + entryEle), ex);
            return value;
        }
    }

    public static Object parseKeyElement(Element keyEle, String defaultKeyTypeClassName) throws XMLParseException {
        List el = keyEle.elements();
        Element subElement = null;
        for (int i = 0; i < el.size(); ++i) {
            Element e = (Element)el.get(i);
            if (COMMENT_ELEMENT.equals(e.getName())) continue;
            if (subElement != null) {
                throw new XMLParseException("<key> element must not contain more than one value sub-element" + keyEle);
            }
            subElement = e;
        }
        Attribute valueAttribute = keyEle.attribute("value");
        if (valueAttribute != null && subElement != null) {
            throw new XMLParseException("<entry> element is only allowed to contain either 'value' attribute OR <value> sub-element" + subElement);
        }
        if (valueAttribute != null) {
            try {
                return XmlDataParser.buildTypedStringValue(keyEle.attributeValue("value"), defaultKeyTypeClassName, keyEle);
            }
            catch (ClassNotFoundException e) {
                return keyEle.attributeValue("value");
            }
        }
        if (subElement != null) {
            return XmlDataParser.parseDataSubElement(subElement, defaultKeyTypeClassName);
        }
        throw new XMLParseException("<entry> element must specify a value" + keyEle);
    }

    public static Properties parsePropsElement(Element propsEle) throws XMLParseException {
        Properties props = new Properties();
        List propEles = propsEle.elements(PROP_ELEMENT);
        for (Element propEle : propEles) {
            String key = propEle.attributeValue("key");
            String value = propEle.getTextTrim();
            props.put(key, value);
        }
        return props;
    }

    public static String getXmlAttributeVal(Element e, String name) throws Exception {
        Assert.notNull((Object)e, "Paramter element is null.", new Object[0]);
        Assert.notBlank(name, "Paramter name is null.", new Object[0]);
        return e.attributeValue(name);
    }

    public static String getXmlAttributeVal(Element e, String name, String defaultVal) throws Exception {
        Assert.notNull((Object)e, "Paramter element is null.", new Object[0]);
        Assert.notBlank(name, "Paramter name is null.", new Object[0]);
        String value = e.attributeValue(name);
        return value == null ? defaultVal : value;
    }

    static {
        classPool.put("int", Integer.class);
        classPool.put("long", Long.class);
        classPool.put("date", Date.class);
        classPool.put("string", String.class);
    }
}

