/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.InetAddresses;
import com.easycodebox.common.zookeeper.ZkNodeNameMaker;
import java.net.SocketException;

public class ZkIpNodeNameMaker
implements ZkNodeNameMaker {
    private static final Logger LOG = LoggerFactory.getLogger(ZkIpNodeNameMaker.class);
    private String prefixNodeName;
    private String ipPrefix = "";
    private String ipPostfix = "";

    @Override
    public String make() {
        this.prefixNodeName = this.prefixNodeName == null ? "" : this.prefixNodeName;
        this.prefixNodeName = this.prefixNodeName.endsWith("/") ? this.prefixNodeName : this.prefixNodeName + "/";
        String name = null;
        try {
            String ip = InetAddresses.getLocalIp();
            name = this.prefixNodeName + this.ipPrefix + ip + this.ipPostfix;
        }
        catch (SocketException e) {
            LOG.error((Object)"Make zookeeper node name error.", e);
        }
        return name;
    }

    public String getPrefixNodeName() {
        return this.prefixNodeName;
    }

    public void setPrefixNodeName(String prefixNodeName) {
        this.prefixNodeName = prefixNodeName;
    }

    public String getIpPrefix() {
        return this.ipPrefix;
    }

    public void setIpPrefix(String ipPrefix) {
        this.ipPrefix = ipPrefix;
    }

    public String getIpPostfix() {
        return this.ipPostfix;
    }

    public void setIpPostfix(String ipPostfix) {
        this.ipPostfix = ipPostfix;
    }
}

