/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper;

import com.easycodebox.common.file.PropertiesUtils;
import com.easycodebox.common.zookeeper.ZkDeserializeException;
import com.easycodebox.common.zookeeper.ZkDeserializer;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class ZkPropertiesDeserializer
implements ZkDeserializer<Properties> {
    @Override
    public Properties deserialize(byte[] data) throws ZkDeserializeException {
        if (data == null) {
            return null;
        }
        String str = new String(data);
        if (StringUtils.isBlank((String)str)) {
            return new Properties();
        }
        Properties ps = new Properties();
        try {
            PropertiesUtils.load(ps, str);
        }
        catch (IOException e) {
            throw new ZkDeserializeException("ZkPropertiesDeserializer deserialize data error.", e);
        }
        return ps;
    }
}

