/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper;

import com.easycodebox.common.zookeeper.ZkSerializeException;
import com.easycodebox.common.zookeeper.ZkSerializer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public class ZkResourceSerializer
implements ZkSerializer {
    @Override
    public byte[] serialize(Object data) throws ZkSerializeException {
        byte[] byArray;
        InputStream is = null;
        try {
            if (data instanceof String) {
                is = ResourceUtils.getURL((String)((String)data)).openStream();
            } else if (data instanceof Resource) {
                is = ((Resource)data).getInputStream();
            } else if (data instanceof InputStream) {
                is = (InputStream)data;
            }
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new ZkSerializeException("ZkResourceSerializer serialize error.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    @Override
    public <T> boolean support(Class<T> clazz) {
        return String.class.isAssignableFrom(clazz) || Resource.class.isAssignableFrom(clazz) || InputStream.class.isAssignableFrom(clazz);
    }
}

