/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.curator;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.InetAddresses;
import com.easycodebox.common.validate.Assert;
import com.easycodebox.common.zookeeper.ZkNodeNameMaker;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.data.Stat;

public class CuratorLatentIpNodeNameMaker
implements ZkNodeNameMaker {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorLatentIpNodeNameMaker.class);
    private CuratorFramework client;
    private String prefixNodeName;
    private String defaultIpDataNode;
    private String child;
    private String ipPrefix = "";
    private String ipPostfix = "";

    @Override
    public String make() {
        Assert.notNull((Object)this.client, "'client' can't be null.", new Object[0]);
        Assert.notBlank(this.child, "'child' can't be blank.", new Object[0]);
        this.prefixNodeName = StringUtils.isBlank((String)this.prefixNodeName) ? "/" : this.prefixNodeName;
        String name = null;
        try {
            Stat stat = (Stat)this.client.checkExists().forPath(this.prefixNodeName);
            if (stat != null) {
                List chs = (List)this.client.getChildren().forPath(this.prefixNodeName);
                for (String c : chs) {
                    c = ZKPaths.makePath((String)this.prefixNodeName, (String)c);
                    byte[] ips = (byte[])this.client.getData().forPath(c);
                    if (ips == null) continue;
                    String ip = InetAddresses.getLocalIp();
                    if (!(new String(ips) + ",").contains(this.ipPrefix + ip + this.ipPostfix + ",")) continue;
                    name = c;
                    break;
                }
                if (name == null && StringUtils.isNotBlank((String)this.defaultIpDataNode)) {
                    String defaultNode = ZKPaths.makePath((String)this.prefixNodeName, (String)this.defaultIpDataNode);
                    Stat st = (Stat)this.client.checkExists().forPath(defaultNode);
                    if (st != null) {
                        name = defaultNode;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Make zookeeper node name error.", e);
        }
        return name == null ? null : name + "/" + this.child;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public void setClient(CuratorFramework client) {
        this.client = client;
    }

    public String getPrefixNodeName() {
        return this.prefixNodeName;
    }

    public void setPrefixNodeName(String prefixNodeName) {
        this.prefixNodeName = prefixNodeName;
    }

    public String getIpPrefix() {
        return this.ipPrefix;
    }

    public void setIpPrefix(String ipPrefix) {
        this.ipPrefix = ipPrefix;
    }

    public String getIpPostfix() {
        return this.ipPostfix;
    }

    public void setIpPostfix(String ipPostfix) {
        this.ipPostfix = ipPostfix;
    }

    public String getChild() {
        return this.child;
    }

    public void setChild(String child) {
        this.child = child;
    }

    public String getDefaultIpDataNode() {
        return this.defaultIpDataNode;
    }

    public void setDefaultIpDataNode(String defaultIpDataNode) {
        this.defaultIpDataNode = defaultIpDataNode;
    }
}

