/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.curator;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultCuratorFrameworkFactory
implements FactoryBean<CuratorFramework>,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCuratorFrameworkFactory.class);
    private CuratorFramework client;
    private String connectString;
    private RetryPolicy retryPolicy;
    private Integer sessionTimeoutMs;
    private Integer connectionTimeoutMs;
    private byte[] defaultData;
    private boolean canBeReadOnly;

    public void destroy() throws Exception {
        if (this.client != null) {
            LOG.info("Shutdown zooKeeper.");
            this.client.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notBlank(this.connectString, "'connectString' cannot be blank.", new Object[0]);
        if (this.retryPolicy == null) {
            this.retryPolicy = new ExponentialBackoffRetry(1000, 3);
        }
    }

    public CuratorFramework getObject() throws Exception {
        if (this.client == null) {
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.connectString).retryPolicy(this.retryPolicy).canBeReadOnly(this.canBeReadOnly).defaultData(this.defaultData);
            if (this.sessionTimeoutMs != null) {
                builder.sessionTimeoutMs(this.sessionTimeoutMs.intValue());
            }
            if (this.connectionTimeoutMs != null) {
                builder.connectionTimeoutMs(this.connectionTimeoutMs.intValue());
            }
            this.client = builder.build();
            this.client.start();
            LOG.info("Create zooKeeper instance successfully.");
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return CuratorFramework.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public void setClient(CuratorFramework client) {
        this.client = client;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public Integer getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public void setSessionTimeoutMs(Integer sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public Integer getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(Integer connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public byte[] getDefaultData() {
        return this.defaultData;
    }

    public void setDefaultData(byte[] defaultData) {
        this.defaultData = defaultData;
    }

    public boolean isCanBeReadOnly() {
        return this.canBeReadOnly;
    }

    public void setCanBeReadOnly(boolean canBeReadOnly) {
        this.canBeReadOnly = canBeReadOnly;
    }
}

