/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.curator;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.lang.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperTest {
    private CuratorFramework client;

    public ZooKeeperTest(CuratorFramework client) {
        this.client = client;
    }

    public <T extends Enum<T>> void addCfgFile2LatentIoNode(String prefixNodeName, T env, String[] cfgFiles) {
        Enum[] envs = (Enum[])env.getDeclaringClass().getEnumConstants();
        try {
            for (Enum envTmp : envs) {
                String node = ZKPaths.makePath((String)prefixNodeName, (String)envTmp.name());
                Stat stat = (Stat)this.client.checkExists().forPath(node);
                byte[] data = StringUtils.join((Object[])((IpArrays)((Object)envTmp)).getIps(), (String)",").getBytes();
                if (stat == null) {
                    this.client.create().forPath(node, data);
                } else {
                    this.client.setData().forPath(node, data);
                }
                if (env != envTmp) continue;
                for (String file : cfgFiles) {
                    String fileNode = node + "/" + FilenameUtils.getName((String)file);
                    stat = (Stat)this.client.checkExists().forPath(fileNode);
                    try (InputStream input = ZooKeeperTest.class.getResourceAsStream(file);){
                        if (stat == null) {
                            this.client.create().forPath(fileNode, IOUtils.toByteArray((InputStream)input));
                            continue;
                        }
                        this.client.setData().forPath(fileNode, IOUtils.toByteArray((InputStream)input));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String connectString = "192.168.1.101:2181,192.168.1.102:2181,192.168.1.103:2181/conf/easycode/auth";
        CuratorFramework client = null;
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        try {
            client = CuratorFrameworkFactory.newClient((String)connectString, (RetryPolicy)retryPolicy);
            client.start();
            ZooKeeperTest test = new ZooKeeperTest(client);
            test.addCfgFile2LatentIoNode("", Envs.DEV, new String[]{"zk-test.properties"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)client);
        }
    }

    static enum Envs implements IpArrays,
    DetailEnum<String>
    {
        DEV("DEV", "\u5f00\u53d1\u73af\u5883"){

            @Override
            public String[] getIps() {
                return new String[]{"192.168.1.101", "192.168.1.102", "192.168.1.103", "192.168.1.104"};
            }
        }
        ,
        TEST("TEST", "\u6d4b\u8bd5\u73af\u5883"){

            @Override
            public String[] getIps() {
                return new String[0];
            }
        }
        ,
        PRE("PRE", "\u9884\u53d1\u73af\u5883"){

            @Override
            public String[] getIps() {
                return new String[0];
            }
        }
        ,
        PROD("PROD", "\u751f\u4ea7\u73af\u5883"){

            @Override
            public String[] getIps() {
                return new String[0];
            }
        };

        private final String value;
        private final String desc;

        private Envs(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getDesc() {
            return this.desc;
        }

        @Override
        public String getClassName() {
            return this.name();
        }
    }

    public static interface IpArrays {
        public String[] getIps();
    }
}

