/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.zkclient;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.InetAddresses;
import com.easycodebox.common.validate.Assert;
import com.easycodebox.common.zookeeper.ZkNodeNameMaker;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkLatentIpNodeNameMaker
implements ZkNodeNameMaker {
    private static final Logger LOG = LoggerFactory.getLogger(ZkLatentIpNodeNameMaker.class);
    private ZooKeeper client;
    private String prefixNodeName;
    private String defaultIpDataNode;
    private String child;
    private String ipPrefix = "";
    private String ipPostfix = "";

    @Override
    public String make() {
        Assert.notNull((Object)this.client, "'client' can't be null.", new Object[0]);
        Assert.notBlank(this.child, "'child' can't be blank.", new Object[0]);
        this.prefixNodeName = StringUtils.isBlank((String)this.prefixNodeName) ? "/" : this.prefixNodeName;
        String name = null;
        try {
            Stat stat = this.client.exists(this.prefixNodeName, false);
            if (stat != null) {
                String defaultNode;
                Stat st;
                List chs = this.client.getChildren(this.prefixNodeName, false);
                for (String c : chs) {
                    c = this.prefixNodeName.endsWith("/") ? this.prefixNodeName + c : this.prefixNodeName + "/" + c;
                    byte[] ips = this.client.getData(c, false, stat);
                    if (ips == null) continue;
                    String ip = InetAddresses.getLocalIp();
                    if (!(new String(ips) + ",").contains(this.ipPrefix + ip + this.ipPostfix + ",")) continue;
                    name = c;
                    break;
                }
                if (name == null && StringUtils.isNotBlank((String)this.defaultIpDataNode) && (st = this.client.exists(defaultNode = this.prefixNodeName.endsWith("/") ? this.prefixNodeName + this.defaultIpDataNode : this.prefixNodeName + "/" + this.defaultIpDataNode, false)) != null) {
                    name = defaultNode;
                }
            }
        }
        catch (InterruptedException | SocketException | KeeperException e) {
            LOG.error((Object)"Make zookeeper node name error.", e);
        }
        return name == null ? null : name + "/" + this.child;
    }

    public ZooKeeper getClient() {
        return this.client;
    }

    public void setClient(ZooKeeper client) {
        this.client = client;
    }

    public String getPrefixNodeName() {
        return this.prefixNodeName;
    }

    public void setPrefixNodeName(String prefixNodeName) {
        this.prefixNodeName = prefixNodeName;
    }

    public String getIpPrefix() {
        return this.ipPrefix;
    }

    public void setIpPrefix(String ipPrefix) {
        this.ipPrefix = ipPrefix;
    }

    public String getIpPostfix() {
        return this.ipPostfix;
    }

    public void setIpPostfix(String ipPostfix) {
        this.ipPostfix = ipPostfix;
    }

    public String getChild() {
        return this.child;
    }

    public void setChild(String child) {
        this.child = child;
    }

    public String getDefaultIpDataNode() {
        return this.defaultIpDataNode;
    }

    public void setDefaultIpDataNode(String defaultIpDataNode) {
        this.defaultIpDataNode = defaultIpDataNode;
    }
}

