/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.zkclient;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import com.easycodebox.common.zookeeper.ZkDeserializeException;
import com.easycodebox.common.zookeeper.ZkDeserializer;
import com.easycodebox.common.zookeeper.ZkNodeNameMaker;
import com.easycodebox.common.zookeeper.ZkSerializeException;
import com.easycodebox.common.zookeeper.ZkSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.springframework.beans.factory.InitializingBean;

public class ZkNode<T>
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ZkNode.class);
    private boolean debug = false;
    private ZooKeeper client;
    private boolean watchBool;
    private Watcher watchObj;
    private Stat stat;
    private String nodeName;
    private ZkNodeNameMaker maker;
    private ZkDeserializer<T> deserializer;
    private ZkSerializer serializer;
    private int version = -1;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.client, "'client' can't be null.", new Object[0]);
        if (this.nodeName == null && this.maker == null) {
            throw new IllegalArgumentException("'nodeName' and 'maker' at least one has value.");
        }
    }

    public Object load() throws KeeperException, InterruptedException, ZkDeserializeException {
        String name;
        String string = name = StringUtils.isBlank((String)this.nodeName) ? this.maker.make() : this.nodeName;
        if (name == null) {
            return null;
        }
        byte[] data = null;
        data = this.watchObj == null ? this.client.getData(name, this.watchBool, this.stat) : this.client.getData(name, this.watchObj, this.stat);
        if (this.debug) {
            LOG.info((Object)"ZooKeeper get data. path: {0} --- data: {1}", name, data == null ? null : new String(data));
        }
        if (this.deserializer != null) {
            return this.deserializer.deserialize(data);
        }
        return data;
    }

    public void store(Object data) throws KeeperException, InterruptedException, ZkSerializeException {
        String name;
        String string = name = StringUtils.isBlank((String)this.nodeName) ? this.maker.make() : this.nodeName;
        if (name == null) {
            return;
        }
        byte[] bytes = null;
        if (data != null && this.serializer != null && this.serializer.support(data.getClass())) {
            bytes = this.serializer.serialize(data);
        } else if (data != null) {
            bytes = data.toString().getBytes();
        }
        this.client.setData(name, bytes, this.version);
        if (this.debug) {
            LOG.info((Object)"ZooKeeper set data. path: {0} --- data: {1}", name, bytes == null ? null : new String(bytes));
        }
    }

    public ZooKeeper getClient() {
        return this.client;
    }

    public void setClient(ZooKeeper client) {
        this.client = client;
    }

    public boolean isWatchBool() {
        return this.watchBool;
    }

    public void setWatchBool(boolean watchBool) {
        this.watchBool = watchBool;
    }

    public Watcher getWatchObj() {
        return this.watchObj;
    }

    public void setWatchObj(Watcher watchObj) {
        this.watchObj = watchObj;
    }

    public Stat getStat() {
        return this.stat;
    }

    public void setStat(Stat stat) {
        this.stat = stat;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public ZkNodeNameMaker getMaker() {
        return this.maker;
    }

    public void setMaker(ZkNodeNameMaker maker) {
        this.maker = maker;
    }

    public ZkDeserializer<T> getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(ZkDeserializer<T> deserializer) {
        this.deserializer = deserializer;
    }

    public ZkSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ZkSerializer serializer) {
        this.serializer = serializer;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

