/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.zookeeper.zkclient;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ZooKeeperFactory
implements FactoryBean<ZooKeeper>,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperFactory.class);
    private ZooKeeper client;
    private CountDownLatch count = new CountDownLatch(1);
    private String connectString;
    private int sessionTimeout;
    private Watcher watcher;
    private boolean canBeReadOnly;
    private Long sessionId;
    private byte[] sessionPasswd;

    public void destroy() throws Exception {
        if (this.client != null) {
            LOG.info("Shutdown zooKeeper.");
            this.client.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notBlank(this.connectString, "'connectString' cannot be blank.", new Object[0]);
    }

    public ZooKeeper getObject() throws Exception {
        if (this.client == null) {
            Watcher newWatcher = new Watcher(){

                public void process(WatchedEvent event) {
                    LOG.info("ZooKeeper trigger event : " + event);
                    if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        ZooKeeperFactory.this.count.countDown();
                    }
                    if (ZooKeeperFactory.this.watcher != null) {
                        ZooKeeperFactory.this.watcher.process(event);
                    }
                }
            };
            this.client = this.sessionId != null ? new ZooKeeper(this.connectString, this.sessionTimeout, newWatcher, this.sessionId.longValue(), this.sessionPasswd, this.canBeReadOnly) : new ZooKeeper(this.connectString, this.sessionTimeout, newWatcher, this.canBeReadOnly);
            this.count.await();
            LOG.info("Create zooKeeper instance successfully.");
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return ZooKeeper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Watcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public boolean isCanBeReadOnly() {
        return this.canBeReadOnly;
    }

    public void setCanBeReadOnly(boolean canBeReadOnly) {
        this.canBeReadOnly = canBeReadOnly;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public byte[] getSessionPasswd() {
        return this.sessionPasswd;
    }

    public void setSessionPasswd(byte[] sessionPasswd) {
        this.sessionPasswd = sessionPasswd;
    }
}

