/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.live.sdk;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.edusoho.live.sdk.ClientConfig;
import com.edusoho.live.sdk.EsliveApiException;
import com.edusoho.live.sdk.common.BooleanResponse;
import com.edusoho.live.sdk.common.ErrorResponse;
import com.edusoho.live.sdk.common.Pager;
import com.edusoho.live.sdk.common.QueryParams;
import com.edusoho.live.sdk.common.Utils;
import com.edusoho.live.sdk.model.Member;
import com.edusoho.live.sdk.model.MemberListParams;
import com.edusoho.live.sdk.model.MemberListVisitsParams;
import com.edusoho.live.sdk.model.MemberVisit;
import com.edusoho.live.sdk.model.Replay;
import com.edusoho.live.sdk.model.Role;
import com.edusoho.live.sdk.model.Room;
import com.edusoho.live.sdk.model.RoomCreateParams;
import com.edusoho.live.sdk.model.RoomUpdateParams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsliveApiClient {
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String userAgent = "ESLiveApiJavaSDK/1.0.2";
    private static final MediaType JSON_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final Gson gson = new Gson();
    private final String accessKey;
    private final String secretKey;
    private final String server;
    private Logger log;

    public EsliveApiClient(ClientConfig config) {
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.server = Utils.isEmpty(config.getServer()) ? "live.edusoho.com" : config.getServer();
        this.client = new OkHttpClient.Builder().build();
        if (Boolean.TRUE.equals(config.getDebug())) {
            this.log = LoggerFactory.getLogger(EsliveApiClient.class);
        }
    }

    public Room roomGet(Long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id.toString());
        return (Room)this.get("/room/get", (Map<String, String>)params, (Type)((Object)Room.class));
    }

    public Room roomCreate(RoomCreateParams params) {
        return (Room)this.post("/room/create", params, (Type)((Object)Room.class));
    }

    public Room roomUpdate(RoomUpdateParams params) {
        return (Room)this.post("/room/update", params, (Type)((Object)Room.class));
    }

    public BooleanResponse roomClose(Long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id.toString());
        return (BooleanResponse)this.post("/room/close", params, (Type)((Object)BooleanResponse.class));
    }

    public BooleanResponse roomDelete(Long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id.toString());
        return (BooleanResponse)this.post("/room/delete", params, (Type)((Object)BooleanResponse.class));
    }

    public Pager<Member> memberList(MemberListParams params) {
        Type pagerType = new TypeToken<Pager<Member>>(){}.getType();
        return (Pager)this.get("/member/list", params, pagerType);
    }

    public Pager<MemberVisit> memberListVisits(MemberListVisitsParams params) {
        Type pagerType = new TypeToken<Pager<MemberVisit>>(){}.getType();
        return (Pager)this.get("/member/listVisits", params, pagerType);
    }

    public Replay replayGet(Long roomId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roomId", roomId.toString());
        return (Replay)this.get("/replay/get", (Map<String, String>)params, (Type)((Object)Replay.class));
    }

    public List<Replay> replayGets(List<Long> roomIds) {
        String roomIdsStr = roomIds.stream().map(Object::toString).collect(Collectors.joining(","));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roomIds", roomIdsStr);
        Type listType = new TypeToken<List<Replay>>(){}.getType();
        return (List)this.get("/replay/gets", params, listType);
    }

    public BooleanResponse replayDelete(Long roomId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roomId", roomId.toString());
        return (BooleanResponse)this.post("/replay/delete", params, (Type)((Object)BooleanResponse.class));
    }

    public String roomGetEnterUrl(Long roomId, Long userId, String name, Role role) {
        String token = this.generateEnterToken(roomId, userId, name, role);
        return "https://" + this.server + "/h5/room/" + roomId.toString() + "/enter?token=" + token;
    }

    public String replayGetEnterUrl(Long roomId, Long userId, String name, Role role) {
        String token = this.generateEnterToken(roomId, userId, name, role);
        return "https://" + this.server + "/h5/replay/" + roomId.toString() + "/enter?token=" + token;
    }

    private String generateEnterToken(Long roomId, Long userId, String name, Role role) {
        return JWT.create().withKeyId(this.accessKey).withIssuer("live client api").withClaim("rid", roomId).withClaim("uid", userId).withClaim("name", name).withClaim("role", role.name().toLowerCase()).withExpiresAt(new Date(System.currentTimeMillis() + 1800000L)).sign(Algorithm.HMAC256((String)this.secretKey));
    }

    private <T> T get(String uri, QueryParams params, Type responseClass) {
        uri = Utils.appendQueryParams(uri, params);
        return this.request(GET, uri, null, responseClass);
    }

    private <T> T get(String uri, Map<String, String> params, Type responseClass) {
        uri = Utils.appendQueryParams(uri, params);
        return this.request(GET, uri, null, responseClass);
    }

    private <T> T post(String uri, Object params, Type responseClass) {
        return this.request(POST, uri, params, responseClass);
    }

    private <T> T request(String method, String uri, Object params, Type responseClass) {
        String result;
        Response response;
        String url = "https://" + this.server + "/api-v2" + uri;
        String token = JWT.create().withKeyId(this.accessKey).withIssuer("live api").withExpiresAt(new Date(System.currentTimeMillis() + 300000L)).sign(Algorithm.HMAC256((String)this.secretKey));
        Request.Builder req = new Request.Builder().url(url).header("User-Agent", userAgent).header("Authorization", "Bearer " + token);
        if (POST.equals(method)) {
            String body = this.gson.toJson(params);
            req.post(RequestBody.create((String)body, (MediaType)JSON_TYPE));
        }
        if (this.log != null) {
            this.log.info("Send {} request to {}", (Object)method, (Object)url);
        }
        try {
            response = this.client.newCall(req.build()).execute();
        }
        catch (IOException e) {
            throw new EsliveApiException("CLIENT_REQUEST_FAILED", e.getMessage());
        }
        if (response.body() == null) {
            throw new EsliveApiException("CLIENT_RESPONSE_FAILED", "Response body is null");
        }
        try {
            result = response.body().string();
        }
        catch (IOException e) {
            throw new EsliveApiException("CLIENT_RESPONSE_FAILED", e.getMessage());
        }
        if (this.log != null) {
            this.log.info("Received response from: {}, body: {}", (Object)url, (Object)result);
        }
        if (Utils.isEmpty(result)) {
            throw new EsliveApiException("CLIENT_RESPONSE_FAILED", "Response body is empty");
        }
        if (response.isSuccessful()) {
            return (T)this.gson.fromJson(result, responseClass);
        }
        ErrorResponse error = (ErrorResponse)this.gson.fromJson(result, ErrorResponse.class);
        throw new EsliveApiException(error.getCode(), error.getMessage());
    }
}

