/*
 * Decompiled with CFR 0.152.
 */
package com.elibom.client;

import com.elibom.client.Account;
import com.elibom.client.Delivery;
import com.elibom.client.HttpServerException;
import com.elibom.client.Message;
import com.elibom.client.Preconditions;
import com.elibom.client.Schedule;
import com.elibom.client.User;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElibomRestClient {
    private static final String DEFAULT_HOST = "https://www.elibom.com";
    private final String LIB_VERSION = "java-0.2.6";
    private String host;
    private String username;
    private String apiPassword;

    public ElibomRestClient(String username, String apiPassword) {
        this(username, apiPassword, DEFAULT_HOST);
    }

    public ElibomRestClient(String username, String apiPassword, String host) {
        Preconditions.notEmpty(username, "no username provided");
        Preconditions.notEmpty(apiPassword, "no apiPassword provided");
        Preconditions.notEmpty(host, "no host provided");
        Preconditions.isUrl(host, "host is not a valid URL");
        this.username = username;
        this.apiPassword = apiPassword;
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
    }

    public String sendMessage(String to, String text) throws HttpServerException, RuntimeException {
        Preconditions.notEmpty(to, "no destinations provided");
        Preconditions.notEmpty(text, "no text provided");
        Preconditions.maxLength(text, 160, "text has more than 160 characters");
        try {
            JSONObject json = new JSONObject().put("to", (Object)to).put("text", (Object)text);
            HttpURLConnection connection = this.post("/messages", json);
            return this.getJsonObject(connection.getInputStream()).getString("deliveryToken");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String sendMessage(String to, String text, String campaign) throws HttpServerException, RuntimeException {
        Preconditions.notEmpty(to, "no destinations provided");
        Preconditions.notEmpty(text, "no text provided");
        Preconditions.notEmpty(campaign, "no campaign provided");
        Preconditions.maxLength(text, 160, "text has more than 160 characters");
        try {
            JSONObject json = new JSONObject().put("to", (Object)to).put("text", (Object)text).put("campaign", (Object)campaign);
            HttpURLConnection connection = this.post("/messages", json);
            return this.getJsonObject(connection.getInputStream()).getString("deliveryToken");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long scheduleMessage(String to, String text, Date scheduleDate) throws HttpServerException, RuntimeException {
        Preconditions.notEmpty(to, "no destinations provided");
        Preconditions.notEmpty(text, "no text provided");
        Preconditions.maxLength(text, 160, "text has more than 160 characters");
        Preconditions.notNull(scheduleDate, "no scheduleDate provided");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            JSONObject json = new JSONObject().put("to", (Object)to).put("text", (Object)text).put("scheduleDate", (Object)sdf.format(scheduleDate));
            HttpURLConnection connection = this.post("/messages", json);
            return this.getJsonObject(connection.getInputStream()).getLong("scheduleId");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long scheduleMessage(String to, String text, Date scheduleDate, String campaign) throws HttpServerException, RuntimeException {
        Preconditions.notEmpty(to, "no destinations provided");
        Preconditions.notEmpty(text, "no text provided");
        Preconditions.maxLength(text, 160, "text has more than 160 characters");
        Preconditions.notEmpty(campaign, "no campaign provided");
        Preconditions.notNull(scheduleDate, "no scheduleDate provided");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            JSONObject json = new JSONObject().put("to", (Object)to).put("text", (Object)text).put("scheduleDate", (Object)sdf.format(scheduleDate)).put("campaign", (Object)campaign);
            HttpURLConnection connection = this.post("/messages", json);
            return this.getJsonObject(connection.getInputStream()).getLong("scheduleId");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Message> getLastMessages(int numMessages) throws HttpServerException, RuntimeException {
        Preconditions.isInteger(numMessages, "numMessages must be greater than zero");
        try {
            HttpURLConnection connection = this.get("/messages?perPage=" + numMessages + "&user=" + this.username);
            JSONObject json = this.getJsonObject(connection.getInputStream());
            ArrayList<Message> messages = new ArrayList<Message>();
            JSONArray jm = json.getJSONArray("messages");
            for (int i = 0; i < jm.length(); ++i) {
                messages.add(new Message(jm.getJSONObject(i)));
            }
            return messages;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Message> getLastMessages(int numMessages, Date startDate, Date endDate) throws HttpServerException, RuntimeException {
        Preconditions.isInteger(numMessages, "numMessages must be greater than zero");
        Preconditions.notNull(startDate, "no startDate provided");
        Preconditions.notNull(endDate, "no endDate provided");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            HttpURLConnection connection = this.get("/messages?perPage=" + numMessages + "&user=" + this.username + "&startDate=" + sdf.format(startDate) + "&endDate=" + sdf.format(endDate));
            JSONObject json = this.getJsonObject(connection.getInputStream());
            ArrayList<Message> messages = new ArrayList<Message>();
            JSONArray jm = json.getJSONArray("messages");
            for (int i = 0; i < jm.length(); ++i) {
                messages.add(new Message(jm.getJSONObject(i)));
            }
            return messages;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Delivery getDelivery(String deliveryId) throws HttpServerException, RuntimeException {
        Preconditions.notEmpty(deliveryId, "no deliveryId provided");
        try {
            HttpURLConnection connection = this.get("/messages/" + deliveryId);
            JSONObject json = this.getJsonObject(connection.getInputStream());
            return new Delivery(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Schedule> getScheduledMessages() throws HttpServerException, RuntimeException {
        try {
            HttpURLConnection connection = this.get("/schedules/scheduled");
            ArrayList<Schedule> schedules = new ArrayList<Schedule>();
            JSONArray json = this.getJsonArray(connection.getInputStream());
            for (int i = 0; i < json.length(); ++i) {
                schedules.add(new Schedule(json.getJSONObject(i)));
            }
            return schedules;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Schedule getScheduledMessage(long id) throws HttpServerException, RuntimeException {
        try {
            HttpURLConnection connection = this.get("/schedules/" + id);
            return new Schedule(this.getJsonObject(connection.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void unschedule(long id) throws HttpServerException, RuntimeException {
        try {
            this.delete("/schedules/" + id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public List<User> getUsers() throws HttpServerException, RuntimeException {
        try {
            HttpURLConnection connection = this.get("/users");
            ArrayList<User> users = new ArrayList<User>();
            JSONArray json = this.getJsonArray(connection.getInputStream());
            for (int i = 0; i < json.length(); ++i) {
                users.add(new User(json.getJSONObject(i)));
            }
            return users;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public User getUser(long id) throws HttpServerException, RuntimeException {
        try {
            HttpURLConnection connection = this.get("/users/" + id);
            return new User(this.getJsonObject(connection.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Account getAccount() throws HttpServerException, RuntimeException {
        try {
            HttpURLConnection connection = this.get("/account");
            return new Account(this.getJsonObject(connection.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection post(String resource, JSONObject json) throws JSONException, IOException {
        URL url = this.buildUrl(resource);
        OutputStreamWriter out = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Authorization", this.buildAuthorizationHeader());
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("X-API-Source", "java-0.2.6");
            connection.setDoOutput(true);
            out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            json.write((Writer)out);
            out.flush();
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                throw new HttpServerException(statusCode, this.getJsonObject(connection.getErrorStream()));
            }
            HttpURLConnection httpURLConnection = connection;
            this.closeResource(out);
            return httpURLConnection;
        }
        catch (Throwable throwable) {
            this.closeResource(out);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection get(String resource) throws IOException, JSONException {
        URL url = this.buildUrl(resource);
        Closeable out = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Authorization", this.buildAuthorizationHeader());
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("X-API-Source", "java-0.2.6");
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                throw new HttpServerException(statusCode, this.getJsonObject(connection.getErrorStream()));
            }
            HttpURLConnection httpURLConnection = connection;
            return httpURLConnection;
        }
        finally {
            this.closeResource(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection delete(String resource) throws IOException, JSONException {
        URL url = this.buildUrl(resource);
        Closeable out = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("Authorization", this.buildAuthorizationHeader());
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("X-API-Source", "java-0.2.6");
            connection.connect();
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                throw new HttpServerException(statusCode, this.getJsonObject(connection.getErrorStream()));
            }
            HttpURLConnection httpURLConnection = connection;
            return httpURLConnection;
        }
        finally {
            this.closeResource(out);
        }
    }

    private URL buildUrl(String resource) {
        Preconditions.notEmpty(resource, "no resource provided");
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        try {
            return new URL(this.host + resource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildAuthorizationHeader() {
        String credentials = this.username + ":" + this.apiPassword;
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])credentials.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getJsonObject(InputStream stream) throws JSONException, IOException {
        if (stream == null) {
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            String body = this.getBody(in);
            JSONObject jSONObject = new JSONObject(body);
            return jSONObject;
        }
        finally {
            this.closeResource(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getJsonArray(InputStream stream) throws JSONException, IOException {
        if (stream == null) {
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            String body = this.getBody(in);
            JSONArray jSONArray = new JSONArray(body);
            return jSONArray;
        }
        finally {
            this.closeResource(stream);
        }
    }

    private String getBody(BufferedReader in) throws IOException {
        String line;
        String body = "";
        while ((line = in.readLine()) != null) {
            body = body + line;
        }
        return body;
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

