/*
 * Decompiled with CFR 0.152.
 */
package com.elibom.client;

import java.util.HashMap;
import org.json.JSONObject;

public class HttpServerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private JSONObject body;

    public HttpServerException(int statusCode) {
        this(statusCode, null);
    }

    public HttpServerException(int statusCode, JSONObject body) {
        this.statusCode = statusCode;
        this.body = body;
    }

    @Override
    public String getMessage() {
        return "The server returned with status " + this.statusCode + " " + this.getStatusDescription(this.statusCode);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public JSONObject getBody() {
        return this.body;
    }

    public String getStatusDescription(int statusCode) {
        HashMap<Integer, String> status = new HashMap<Integer, String>();
        status.put(400, "Bad Request");
        status.put(401, "Unauthorized");
        status.put(404, "Not Found");
        status.put(409, "Conflict");
        status.put(500, "Internal Server Error");
        String ret = (String)status.get(statusCode);
        if (ret == null) {
            return "";
        }
        return ret;
    }
}

