/*
 * Decompiled with CFR 0.152.
 */
package com.elibom.client;

import java.net.MalformedURLException;
import java.net.URL;

public class Preconditions {
    public static void notNull(Object object, String message) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("A precondition failed: " + message);
        }
    }

    public static void notEmpty(String value, String message) throws IllegalArgumentException {
        if (value == null || "".equals(value.trim())) {
            throw new IllegalArgumentException("A precondition failed: " + message);
        }
    }

    public static void maxLength(String value, int maxLength, String message) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        if (value.length() > maxLength) {
            throw new IllegalArgumentException("A precondition failed: " + message);
        }
    }

    public static void isUrl(String value, String message) throws IllegalArgumentException {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("A precondition failed: " + message);
        }
    }

    public static void isInteger(int value, String message) throws IllegalArgumentException {
        if (value < 1) {
            throw new IllegalArgumentException("A precondition failed: " + message);
        }
    }
}

