/*
 * Decompiled with CFR 0.152.
 */
package com.elibom.client;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Schedule {
    private JSONObject json;
    private long id;
    private long userId;
    private Date scheduledAt;
    private Date createdAt;
    private String status = "scheduled";
    private boolean isFile;
    private String fileName;
    private boolean fileHasText;
    private String text;
    private String destinations;

    public Schedule(JSONObject json) throws JSONException, ParseException {
        this.json = json;
        this.id = json.getLong("id");
        if (json.has("user")) {
            this.userId = json.getJSONObject("user").getLong("id");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.scheduledAt = sdf.parse(json.getString("scheduledTime"));
        this.createdAt = sdf.parse(json.getString("creationTime"));
        if (json.has("status")) {
            this.status = json.getString("status");
        }
        this.isFile = json.getBoolean("isFile");
        if (this.isFile) {
            this.fileName = json.getString("fileName");
            this.fileHasText = json.getBoolean("fileHasText");
            if (!this.fileHasText) {
                this.text = json.getString("text");
            }
        } else {
            this.destinations = json.getString("destinations");
            this.text = json.getString("text");
        }
    }

    public long getId() {
        return this.id;
    }

    public long getUserId() {
        return this.userId;
    }

    public Date getScheduledAt() {
        return this.scheduledAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFileHasText() {
        return this.fileHasText;
    }

    public String getText() {
        return this.text;
    }

    public String getDestinations() {
        return this.destinations;
    }

    public String toString() {
        return this.json.toString();
    }
}

