/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.SFTPv3FileHandle;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SshClientUtils {
    private static final Logger log = LoggerFactory.getLogger(SshClientUtils.class);

    public static Connection getConnection(String host, String username) {
        return SshClientUtils.getConnection(host, 22, username);
    }

    public static Connection getConnection(String host, int port, String username) {
        return SshClientUtils.getConnection(host, port, username, null);
    }

    public static Connection getConnection(String host, String username, String password) {
        return SshClientUtils.getConnection(host, 22, username, password);
    }

    public static Connection getConnection(String host, int port, String username, String password) {
        Connection connection = null;
        try {
            connection = new Connection(host, port);
            connection.connect();
            boolean isAuthenticate = StringUtils.hasText((String)password) ? connection.authenticateWithPassword(username, password) : connection.authenticateWithNone(username);
            if (isAuthenticate) {
                return connection;
            }
            connection.close();
            throw new RuntimeException("Connection authentication failed.");
        }
        catch (IOException ex) {
            connection.close();
            throw new RuntimeException(ex);
        }
    }

    private static String processStdout(InputStream is) {
        StringBuilder builder = new StringBuilder();
        try {
            StreamGobbler stdout = new StreamGobbler(is);
            char[] chars = IOUtils.toCharArray((InputStream)stdout, (Charset)StandardCharsets.UTF_8);
            if (!ObjectUtils.isEmpty((Object)chars)) {
                builder.append(System.getProperty("line.separator"));
                builder.append(chars);
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return builder.toString();
    }

    public static String execute(Connection connection, String command) {
        Session session = null;
        try {
            session = connection.openSession();
            session.execCommand(command);
            String result = SshClientUtils.processStdout(session.getStdout());
            if (StringUtils.isEmpty((Object)result)) {
                String string = SshClientUtils.processStdout(session.getStderr());
                return string;
            }
            String string = result;
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != session) {
                session.close();
            }
        }
    }

    public static void upLoad(Connection connection, File file, String path) {
        try {
            SshClientUtils.upLoad(connection, new BufferedInputStream(new FileInputStream(file)), path);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void upLoad(Connection connection, byte[] input, String path) {
        SshClientUtils.upLoad(connection, new ByteArrayInputStream(input), path);
    }

    public static void upLoad(Connection connection, InputStream input, String path) {
        SFTPv3Client client = null;
        SFTPv3FileHandle handle = null;
        try {
            int count;
            client = new SFTPv3Client(connection);
            handle = client.createFile(path);
            byte[] buffer = new byte[8192];
            long offset = 0L;
            while ((count = input.read(buffer, 0, buffer.length)) >= 0) {
                client.write(handle, offset, buffer, 0, count);
                offset += (long)count;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != client) {
                if (null != handle) {
                    try {
                        client.closeFile(handle);
                    }
                    catch (IOException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                client.close();
            }
        }
    }

    public static byte[] download(Connection connection, String path) {
        SFTPv3Client client = null;
        SFTPv3FileHandle handle = null;
        try {
            int count;
            client = new SFTPv3Client(connection);
            handle = client.openFileRO(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            long offset = 0L;
            while ((count = client.read(handle, offset, buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, count);
                offset += (long)count;
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != client) {
                if (null != handle) {
                    try {
                        client.closeFile(handle);
                    }
                    catch (IOException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                client.close();
            }
        }
    }

    public static List<String> listNames(Connection connection, String path) {
        SFTPv3Client client = null;
        try {
            client = new SFTPv3Client(connection);
            List files = client.ls(path);
            ArrayList<String> nameList = new ArrayList<String>();
            for (SFTPv3DirectoryEntry entry : files) {
                String fileName = entry.filename.trim();
                if (fileName.equals(".") || fileName.equals("..")) continue;
                nameList.add(fileName);
            }
            ArrayList<String> arrayList = nameList;
            return arrayList;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != client) {
                client.close();
            }
        }
    }
}

