/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;

public class FileDownloadWrapper
implements Closeable {
    private final String fileName;
    private final CloseableHttpResponse response;
    private final InputStream inputStream;

    public FileDownloadWrapper(String fileName, CloseableHttpResponse response) throws UnsupportedOperationException, IOException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("File name can't be null");
        }
        if (response == null) {
            throw new IllegalArgumentException("Response can't be null");
        }
        this.response = response;
        this.inputStream = response.getEntity().getContent();
        this.fileName = fileName;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.response.close();
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

