/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf;

import com.exactpro.sf.FileDownloadWrapper;
import com.exactpro.sf.Matrix;
import com.exactpro.sf.Service;
import com.exactpro.sf.ServiceDescriptors;
import com.exactpro.sf.ServiceImportResult;
import com.exactpro.sf.TestScriptRun;
import com.exactpro.sf.configuration.suri.SailfishURI;
import com.exactpro.sf.exceptions.APICallException;
import com.exactpro.sf.exceptions.APIResponseException;
import com.exactpro.sf.testwebgui.restapi.xml.MatrixList;
import com.exactpro.sf.testwebgui.restapi.xml.XmlBbExecutionStatus;
import com.exactpro.sf.testwebgui.restapi.xml.XmlInfoSFStatus;
import com.exactpro.sf.testwebgui.restapi.xml.XmlLibraryImportResult;
import com.exactpro.sf.testwebgui.restapi.xml.XmlMatrixLinkUploadResponse;
import com.exactpro.sf.testwebgui.restapi.xml.XmlMatrixUploadResponse;
import com.exactpro.sf.testwebgui.restapi.xml.XmlResponse;
import com.exactpro.sf.testwebgui.restapi.xml.XmlRunReference;
import com.exactpro.sf.testwebgui.restapi.xml.XmlStatisticStatusResponse;
import com.exactpro.sf.testwebgui.restapi.xml.XmlTestScriptShortReport;
import com.exactpro.sf.testwebgui.restapi.xml.XmlTestscriptActionResponse;
import com.exactpro.sf.testwebgui.restapi.xml.XmlTestscriptRunDescription;
import com.exactpro.sf.testwebgui.restapi.xml.XmlVariableSets;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SFAPIClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SFAPIClient.class);
    private static final String SFAPI = "sfapi/";
    private static final String SERVICES = "services?environment=!env";
    private static final String SERVICE_DELETE = "services/delete?environment=!env&service=!svc";
    private static final String SERVICE_DELETE_ALL = "services/delete?environment=!env";
    private static final String SERVICE_DELETE_CUSTOM = "services/delete?";
    private static final String SERVICE_STOP = "services/!svc?action=stop&environment=!env";
    private static final String SERVICE_START = "services/!svc?action=start&environment=!env";
    private static final String SERVICES_IMPORT = "services/import?environment=!env&replaceexisting=!re&skipexisting=!se";
    private static final String ENVIRONMENTS = "environment/";
    private static final String ENVIRONMENT_CREATE = "environment/add?name=!name";
    private static final String ENVIRONMENT_DELETE = "environment/delete?name=!name";
    private static final String ENVIRONMENT_RENAME = "environment/rename?oldname=!old&newname=!new";
    private static final String ENVIRONMENT_GET_VARIABLE_SET = "environment/get_variable_set?name=!name";
    private static final String ENVIRONMENT_SET_VARIABLE_SET = "environment/set_variable_set?environment=!name&variable_set=!set";
    private static final String VARIABLE_SETS = "variable_sets/";
    private static final String VARIABLE_SET_DELETE = "variable_sets/delete?name=!name";
    private static final String VARIABLE_SETS_IMPORT = "variable_sets/import?replace_existing=!re";
    private static final String MATRICES = "scripts/";
    private static final String RUN_REFERENCE = "scripts/reference/run";
    private static final String MATRIX_UPLOAD = "scripts/upload";
    private static final String MATRIX_LINK_UPLOAD = "scripts/uploadLink?link=!link";
    private static final String MATRIX_LINK_UPLOAD_BY_PROVIDER = "scripts/uploadLink?link=!link&provider_uri=!provider_uri";
    private static final String MATRIX_DOWNLOAD = "scripts/download?id=!id";
    private static final String MATRIX_RUN = "scripts/";
    private static final String MATRIX_DELETE_BY_ID = "scripts/delete/!id";
    private static final String MATRIX_DELETE_BY_NAME = "scripts/delete/name_!name";
    private static final String MATRIX_DELETE_ALL = "scripts/delete";
    private static final String MATRIX_CONVERT = "scripts/convert?matrix_id=!id&converter_uri=!converter_uri";
    private static final String MATRIX_CONVERT_ENVIRONMENT = "scripts/convert?matrix_id=!id&environment=!environment&converter_uri=!converter_uri";
    private static final String TEST_LIBRARY_UPLOAD = "testlibraries/upload";
    private static final String TEST_SCRIPT_RUNS = "testscriptruns/";
    private static final String TEST_SCRIPT_RUN_INFO = "testscriptruns/!id";
    private static final String TEST_SCRIPT_RUN_COMPILE = "testscriptruns/!id?action=compileScript";
    private static final String TEST_SCRIPT_RUN_RUN_COMPILED_SCRIPT = "testscriptruns/!id?action=runCompileScript";
    private static final String TEST_SCRIPT_RUN_REPORT = "testscriptruns/!id?action=report";
    private static final String TEST_SCRIPT_RUN_SHORTREPORT = "testscriptruns/!id?action=shortreport";
    private static final String TEST_SCRIPT_RUN_REPORT_ZIP = "testscriptruns/!id?action=reportzip";
    private static final String TEST_SCRIPT_RUN_AGGREGATE = "testscriptruns/aggregate";
    private static final String TEST_SCRIPT_RUN_DELETE = "testscriptruns/delete/!id?deleteOnDisk=true";
    private static final String TEST_SCRIPT_RUN_DELETE_ALL = "testscriptruns/delete?deleteOnDisk=true";
    private static final String TEST_SCRIPT_RUN_STOP = "testscriptruns/!id?action=stop";
    private static final String TEST_SCRIPT_RUN_UPDATE = "testscriptruns/update/!id?sfCurrentID=!sfCurrentID";
    private static final String STATS_REGISTER_TAG = "statistics/register_tag?name=!name";
    private static final String STATS_REGISTER_GROUP = "statistics/register_group?name=!name";
    private static final String STATS_REGISTER_TAG_IN_GROUP = "statistics/register_tag?name=!tag&group=!group";
    private static final String RESOURCES_CLEAN_OLDERTHAN = "resources/clean?olderthan=!olderthan";
    private static final String RESOURCES_CLEAN_TARGETS = "resources/clean?targets=!targets";
    private static final String RESOURCES_CLEAN_OLDERTHAN_TARGETS = "resources/clean?olderthan=!olderthan&targets=!targets";
    private static final String CONFIGURATION = "configuration/";
    private static final String LOGGING_CONFIGURATION = "configuration/logging/";
    private static final String CONFIG_STATUS = "config/status";
    private final CloseableHttpClient http;
    private final String rootUrl;
    private final DocumentBuilder docBuilder;
    private final Map<Class<?>, Unmarshaller> unmarshallers = new HashMap();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String defaultServiceHandlerClassName = "com.exactpro.sf.services.CollectorServiceHandler";

    public SFAPIClient(String rootUrl) throws ParserConfigurationException {
        if (rootUrl == null || rootUrl.length() < SFAPI.length()) {
            throw new IllegalArgumentException("Sailfish URL [" + rootUrl + "] is incorrect");
        }
        StringBuilder builder = new StringBuilder(rootUrl);
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        if (!SFAPI.equals(builder.substring(builder.length() - SFAPI.length()))) {
            builder.append(SFAPI);
        }
        this.rootUrl = builder.toString();
        this.http = HttpClients.createDefault();
        this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public Map<String, Service> getServices(String envName) throws APICallException, APIResponseException {
        return this.getServices(envName, false);
    }

    public Map<String, Service> getServices(String envName, boolean setSettingsTag) throws APICallException, APIResponseException {
        if (setSettingsTag && ServiceDescriptors.getInstance() == null) {
            try {
                ServiceDescriptors.init(this.docBuilder);
            }
            catch (IOException e) {
                throw new APICallException(e);
            }
            catch (SAXException e) {
                throw new APICallException(e);
            }
        }
        String url = SERVICES.replaceFirst("!env", envName);
        Document doc = this.getDocument(url);
        HashMap<String, Service> map = new HashMap<String, Service>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Service svc = Service.fromXml(nodes.item(i), "com.exactpro.sf.services.CollectorServiceHandler");
            if (setSettingsTag) {
                svc.setSettingsTag(ServiceDescriptors.forName(svc.getType()).getSettingsTagName());
            }
            map.put(svc.getName(), svc);
        }
        return map;
    }

    public XmlResponse deleteService(String envName, String svcName) throws APICallException, APIResponseException {
        String url = SERVICE_DELETE.replace("!env", envName).replace("!svc", svcName);
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteService(String envName, Service svc) throws APICallException, APIResponseException {
        return this.deleteService(envName, svc.getName());
    }

    public XmlResponse deleteService(String args) throws APICallException, APIResponseException {
        String url = SERVICE_DELETE_CUSTOM + args;
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteAllServices(String envName) throws APICallException, APIResponseException {
        String url = SERVICE_DELETE_ALL.replace("!env", envName);
        return this.getXmlResponse(url);
    }

    public void startService(String envName, String svcName) throws APICallException, APIResponseException {
        String url = this.rootUrl + SERVICE_START.replace("!env", envName).replace("!svc", svcName);
        try {
            logger.debug("Request: {}", (Object)url);
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            res.close();
            return;
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public void startService(String envName, Service svc) throws APICallException, APIResponseException {
        this.startService(envName, svc.getName());
    }

    public void forceMigrateStatistics() throws APICallException, APIResponseException {
        HttpGet migrateDB = new HttpGet(this.rootUrl + "statistics/migrate");
        try {
            CloseableHttpResponse migrateResponse = this.http.execute((HttpUriRequest)migrateDB);
            this.checkHttpResponse(migrateResponse);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlStatisticStatusResponse getStatisticsStatus() throws APICallException {
        XmlStatisticStatusResponse xmlStatisticStatusResponse;
        block8: {
            HttpGet status = new HttpGet(this.rootUrl + "statistics/status");
            CloseableHttpResponse statusResponse = this.http.execute((HttpUriRequest)status);
            try {
                this.checkHttpResponse(statusResponse);
                xmlStatisticStatusResponse = this.unmarshal(XmlStatisticStatusResponse.class, (HttpResponse)statusResponse);
                if (statusResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statusResponse != null) {
                        try {
                            statusResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new APICallException(e);
                }
            }
            statusResponse.close();
        }
        return xmlStatisticStatusResponse;
    }

    public void runBB(long id) throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/run/" + id);
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public void pauseBB() throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/pause");
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public void resumeBB() throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/resume");
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    @Deprecated
    public void stopBB() throws APICallException, APIResponseException {
        this.interruptBB();
    }

    public void interruptBB() throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/interrupt");
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlBbExecutionStatus getBBStatus() throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/status");
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
            return this.unmarshal(XmlBbExecutionStatus.class, (HttpResponse)runResponse);
        }
        catch (IOException e) {
            throw new APICallException(e);
        }
        catch (JAXBException e) {
            throw new APIResponseException(e);
        }
    }

    public InputStream getBBReport() throws APICallException, APIResponseException {
        HttpGet runBB = new HttpGet(this.rootUrl + "bb/report");
        try {
            CloseableHttpResponse runResponse = this.http.execute((HttpUriRequest)runBB);
            this.checkHttpResponse(runResponse);
            return runResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlLibraryImportResult uploadBBLibrary(File libFile, String name) throws APICallException, APIResponseException {
        HttpPost uploadDescription = new HttpPost(this.rootUrl + "bb/upload");
        MultipartEntityBuilder mpb = MultipartEntityBuilder.create();
        mpb.addBinaryBody("file", libFile, ContentType.APPLICATION_OCTET_STREAM, name);
        uploadDescription.setEntity(mpb.build());
        try {
            CloseableHttpResponse response = this.http.execute((HttpUriRequest)uploadDescription);
            this.checkHttpResponse(response);
            return this.unmarshal(XmlLibraryImportResult.class, (HttpResponse)response);
        }
        catch (IOException e) {
            throw new APICallException(e);
        }
        catch (JAXBException e) {
            throw new APIResponseException(e);
        }
    }

    public void stopService(String envName, String svcName) throws APICallException {
        try {
            String url = this.rootUrl + SERVICE_STOP.replace("!env", envName).replace("!svc", svcName);
            logger.debug("Request: {}", (Object)url);
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            res.close();
            return;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public void stopService(String envName, Service svc) throws APICallException, APIResponseException {
        this.stopService(envName, svc.getName());
    }

    public List<ServiceImportResult> importServices(String fileName, String envName, InputStream zipStream, boolean replaceExisting, boolean skipExisting) throws APICallException, APIResponseException {
        String url = this.rootUrl + SERVICES_IMPORT.replace("!env", envName).replace("!re", String.valueOf(replaceExisting)).replace("!se", String.valueOf(skipExisting));
        try {
            MultipartEntityBuilder mpb = MultipartEntityBuilder.create();
            mpb.addBinaryBody("file", zipStream, ContentType.APPLICATION_OCTET_STREAM, fileName);
            logger.debug("Root url: {}", (Object)url);
            HttpPost req = new HttpPost(url);
            req.setEntity(mpb.build());
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            Document doc = this.docBuilder.parse(res.getEntity().getContent());
            Element root = doc.getDocumentElement();
            ArrayList<ServiceImportResult> svcs = new ArrayList<ServiceImportResult>();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                svcs.add(ServiceImportResult.fromXml(children.item(i)));
            }
            res.close();
            return svcs;
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public MatrixList getMatrixList() throws APICallException, APIResponseException, ParseException {
        String url = "scripts/";
        try {
            return this.getResponse(url, MatrixList.class);
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse uploadTestLibrary(InputStream stream, String filename) throws APICallException, APIResponseException {
        return this.uploadTestLibrary(stream, filename, false);
    }

    public XmlResponse uploadTestLibrary(InputStream stream, String filename, boolean overwrite) throws APICallException, APIResponseException {
        XmlResponse xmlResponse;
        block9: {
            String url = this.rootUrl + TEST_LIBRARY_UPLOAD + (overwrite ? "?overwrite=true" : "");
            MultipartEntityBuilder mpb = MultipartEntityBuilder.create();
            mpb.addBinaryBody("file", stream, ContentType.APPLICATION_OCTET_STREAM, filename);
            HttpPost req = new HttpPost(url);
            req.setEntity(mpb.build());
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            try {
                this.checkHttpResponse(res);
                xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
                if (res == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (APIResponseException e) {
                    throw new APIResponseException("URL: " + url, e);
                }
                catch (Exception e) {
                    throw new APICallException(e);
                }
            }
            res.close();
        }
        return xmlResponse;
    }

    public XmlMatrixUploadResponse uploadMatrix(InputStream stream, String filename) throws APICallException, APIResponseException {
        XmlMatrixUploadResponse xmlMatrixUploadResponse;
        block9: {
            String url = this.rootUrl + MATRIX_UPLOAD;
            MultipartEntityBuilder mpb = MultipartEntityBuilder.create();
            mpb.addBinaryBody("file", stream, ContentType.APPLICATION_OCTET_STREAM, filename);
            HttpPost req = new HttpPost(url);
            req.setEntity(mpb.build());
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            try {
                this.checkHttpResponse(res);
                xmlMatrixUploadResponse = this.unmarshal(XmlMatrixUploadResponse.class, (HttpResponse)res);
                if (res == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (APIResponseException e) {
                    throw new APIResponseException("URL: " + url, e);
                }
                catch (Exception e) {
                    throw new APICallException(e);
                }
            }
            res.close();
        }
        return xmlMatrixUploadResponse;
    }

    public XmlMatrixLinkUploadResponse uploadMatrixLink(String link) throws APIResponseException, APICallException {
        String url = this.rootUrl + MATRIX_LINK_UPLOAD.replace("!link", link);
        return this.getMatrixLinkUploadResponse(url);
    }

    public XmlMatrixLinkUploadResponse uploadMatrixLink(String link, SailfishURI providerURI) throws APICallException, APIResponseException {
        String url = this.rootUrl + MATRIX_LINK_UPLOAD_BY_PROVIDER.replace("!link", link).replace("!provider_uri", providerURI.toString());
        return this.getMatrixLinkUploadResponse(url);
    }

    private XmlMatrixLinkUploadResponse getMatrixLinkUploadResponse(String url) throws APIResponseException, APICallException {
        XmlMatrixLinkUploadResponse xmlMatrixLinkUploadResponse;
        block9: {
            HttpPost req = new HttpPost(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            try {
                this.checkHttpResponse(res);
                xmlMatrixLinkUploadResponse = this.unmarshal(XmlMatrixLinkUploadResponse.class, (HttpResponse)res);
                if (res == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (APIResponseException e) {
                    throw new APIResponseException("URL: " + url, e);
                }
                catch (Exception e) {
                    throw new APICallException(e);
                }
            }
            res.close();
        }
        return xmlMatrixLinkUploadResponse;
    }

    public InputStream downloadMatrix(int id) throws APICallException, APIResponseException {
        String url = this.rootUrl + MATRIX_DOWNLOAD.replace("!id", String.valueOf(id));
        try {
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            return res.getEntity().getContent();
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    private XmlTestscriptActionResponse performMatrixActionInt(String matrix, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, List<String> tags, String staticVariables, String subFolder) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(matrix, actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, true, false, tags, staticVariables, subFolder, null);
    }

    private XmlTestscriptActionResponse performMatrixActionInt(String matrix, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, boolean runNetDumper, boolean skipOptional, List<String> tags, String staticVariables, String subFolder, String language) throws APICallException, APIResponseException {
        StringBuilder paramsBuilder = new StringBuilder(matrix);
        paramsBuilder.append("?");
        paramsBuilder.append("action=");
        paramsBuilder.append(actionName);
        if (rangeParam != null && !"".equals(rangeParam)) {
            paramsBuilder.append("&");
            paramsBuilder.append("range=");
            paramsBuilder.append(rangeParam);
        }
        paramsBuilder.append("&");
        paramsBuilder.append("environment=");
        paramsBuilder.append((String)StringUtils.defaultIfEmpty((CharSequence)environmentParam, (CharSequence)"default"));
        paramsBuilder.append("&");
        paramsBuilder.append("encoding=");
        paramsBuilder.append((String)StringUtils.defaultIfEmpty((CharSequence)fileEncodingParam, (CharSequence)"ISO-8859-1"));
        paramsBuilder.append("&");
        paramsBuilder.append("aml=");
        paramsBuilder.append(amlParam);
        paramsBuilder.append("&");
        paramsBuilder.append("continueonfailed=");
        paramsBuilder.append(continueOnFailed);
        paramsBuilder.append("&");
        paramsBuilder.append("autostart=");
        paramsBuilder.append(autoStart);
        paramsBuilder.append("&");
        paramsBuilder.append("autorun=");
        paramsBuilder.append(autoRun);
        paramsBuilder.append("&");
        paramsBuilder.append("ignoreaskforcontinue=");
        paramsBuilder.append(ignoreAskForContinue);
        paramsBuilder.append("&");
        paramsBuilder.append("runnetdumper=");
        paramsBuilder.append(runNetDumper);
        paramsBuilder.append("&");
        paramsBuilder.append("skipoptional=");
        paramsBuilder.append(skipOptional);
        if (tags != null) {
            for (String tag : tags) {
                paramsBuilder.append("&");
                paramsBuilder.append("tag=");
                paramsBuilder.append(tag);
            }
        }
        if (staticVariables != null && !"".equals(staticVariables)) {
            paramsBuilder.append("&");
            paramsBuilder.append("staticvariables=");
            paramsBuilder.append(staticVariables);
        }
        if (subFolder != null && !"".equals(subFolder)) {
            paramsBuilder.append("&");
            paramsBuilder.append("subfolder=");
            paramsBuilder.append(subFolder);
        }
        if (language != null && !"".equals(language)) {
            paramsBuilder.append("&");
            paramsBuilder.append("language=");
            paramsBuilder.append(language);
        }
        String params = paramsBuilder.toString();
        String url = "scripts/" + params;
        logger.debug(url);
        if (!"stop".equals(actionName)) {
            XmlTestscriptActionResponse res = this.getResponse(url, XmlTestscriptActionResponse.class);
            return res != null ? res : new XmlTestscriptActionResponse();
        }
        try {
            CloseableHttpResponse response = this.getHttpResponse(url);
            response.close();
            return new XmlTestscriptActionResponse();
        }
        catch (APIResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlTestscriptActionResponse performMatrixAction(Matrix mat, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, List<String> tags, String staticVariables, String subFolder) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(mat.getId()), actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, tags, staticVariables, subFolder);
    }

    public XmlTestscriptActionResponse performMatrixAction(int id, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, List<String> tags, String staticVariables, String subFolder) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(id), actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, tags, staticVariables, subFolder);
    }

    public XmlTestscriptActionResponse performMatrixAction(int id, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, List<String> tags, String staticVariables, String subFolder, String language) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(id), actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, true, false, tags, staticVariables, subFolder, language);
    }

    public XmlTestscriptActionResponse performMatrixAction(int id, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, boolean runNetDumper, boolean skipOptional, List<String> tags, String staticVariables, String subFolder, String language) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(id), actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, runNetDumper, skipOptional, tags, staticVariables, subFolder, language);
    }

    public XmlTestscriptActionResponse performMatrixAction(String name, String actionName, String rangeParam, String environmentParam, String fileEncodingParam, int amlParam, boolean continueOnFailed, boolean autoStart, boolean autoRun, boolean ignoreAskForContinue, List<String> tags, String staticVariables, String subFolder) throws APICallException, APIResponseException {
        return this.performMatrixActionInt("name_" + name, actionName, rangeParam, environmentParam, fileEncodingParam, amlParam, continueOnFailed, autoStart, autoRun, ignoreAskForContinue, tags, staticVariables, subFolder);
    }

    public XmlRunReference getRunReference() throws APIResponseException, APICallException {
        String url = RUN_REFERENCE;
        try {
            return this.getResponse(url, XmlRunReference.class);
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlTestscriptActionResponse runMatrix(Matrix mat) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(mat.getId()), "start", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public XmlTestscriptActionResponse runMatrix(int id) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(id), "start", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public XmlTestscriptActionResponse runMatrix(String name) throws APICallException, APIResponseException {
        return this.performMatrixActionInt("name_" + name, "start", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public XmlTestscriptActionResponse stopMatrix(Matrix mat) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(mat.getId()), "stop", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public XmlTestscriptActionResponse stopMatrix(int id) throws APICallException, APIResponseException {
        return this.performMatrixActionInt(String.valueOf(id), "stop", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public XmlTestscriptActionResponse stopMatrix(String name) throws APICallException, APIResponseException {
        return this.performMatrixActionInt("name_" + name, "stop", null, "default", "ISO-8859-1", 3, false, false, true, true, null, null, null);
    }

    public List<TestScriptRun> runAllMatrices() throws APICallException, APIResponseException {
        Document doc = this.getDocument("scripts/all?action=start");
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<TestScriptRun> list = new ArrayList<TestScriptRun>();
        for (int i = 0; i < children.getLength(); ++i) {
            list.add(TestScriptRun.fromXml(children.item(i)));
        }
        return list;
    }

    public XmlResponse deleteMatrix(int id) throws APICallException, APIResponseException {
        String url = MATRIX_DELETE_BY_ID.replace("!id", String.valueOf(id));
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteMatrix(Matrix mat) throws APICallException, APIResponseException {
        return this.deleteMatrix(mat.getId());
    }

    public XmlResponse deleteMatrix(String name) throws APICallException, APIResponseException {
        String url = MATRIX_DELETE_BY_NAME.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteAllMatrices() throws APICallException, APIResponseException {
        String url = MATRIX_DELETE_ALL;
        return this.getXmlResponse(url);
    }

    public XmlMatrixUploadResponse convertMatrix(int id, String environment, SailfishURI converterUri) throws APICallException, APIResponseException {
        String url = MATRIX_CONVERT_ENVIRONMENT.replace("!id", String.valueOf(id)).replace("!environment", environment).replace("!converter_uri", converterUri.toString());
        XmlMatrixUploadResponse res = this.getResponse(url, XmlMatrixUploadResponse.class);
        return res != null ? res : new XmlMatrixUploadResponse();
    }

    public XmlMatrixUploadResponse convertMatrix(Matrix mat, String environment, SailfishURI converterUri) throws APICallException, APIResponseException {
        return this.convertMatrix(mat.getId(), environment, converterUri);
    }

    public XmlMatrixUploadResponse convertMatrix(int id, SailfishURI converterUri) throws APICallException, APIResponseException {
        String url = MATRIX_CONVERT.replace("!id", String.valueOf(id)).replace("!converter_uri", converterUri.toString());
        XmlMatrixUploadResponse res = this.getResponse(url, XmlMatrixUploadResponse.class);
        return res != null ? res : new XmlMatrixUploadResponse();
    }

    public XmlMatrixUploadResponse convertMatrix(Matrix mat, SailfishURI converterUri) throws APICallException, APIResponseException {
        return this.convertMatrix(mat.getId(), converterUri);
    }

    public List<TestScriptRun> getTestScriptRunList() throws APICallException, APIResponseException {
        Document doc = this.getDocument(TEST_SCRIPT_RUNS);
        ArrayList<TestScriptRun> list = new ArrayList<TestScriptRun>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            list.add(TestScriptRun.fromXml(nodes.item(i)));
        }
        return list;
    }

    public XmlTestscriptRunDescription getTestScriptRunInfo(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_INFO.replace("!id", String.valueOf(id));
        XmlTestscriptRunDescription res = this.getResponse(url, XmlTestscriptRunDescription.class);
        return res != null ? res : new XmlTestscriptRunDescription();
    }

    public XmlTestScriptShortReport getTestScriptRunShortReport(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_SHORTREPORT.replace("!id", String.valueOf(id));
        XmlTestScriptShortReport res = this.getResponse(url, XmlTestScriptShortReport.class);
        return res != null ? res : new XmlTestScriptShortReport();
    }

    public InputStream getTestScriptRunReport(int id) throws APICallException, APIResponseException {
        String url = this.rootUrl + TEST_SCRIPT_RUN_REPORT.replace("!id", String.valueOf(id));
        try {
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            return res.getEntity().getContent();
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public FileDownloadWrapper getTestScriptRunReportZip(int id) throws APICallException, APIResponseException {
        String url = this.rootUrl + TEST_SCRIPT_RUN_REPORT_ZIP.replace("!id", String.valueOf(id));
        try {
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            return new FileDownloadWrapper(res.getHeaders("content-disposition")[0].getElements()[0].getParameterByName("filename").getValue(), res);
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public InputStream getTestScriptRunAggregateReport(String args) throws APICallException, APIResponseException {
        String url = this.rootUrl + TEST_SCRIPT_RUN_AGGREGATE + (args.isEmpty() ? "" : Character.valueOf('?')) + args;
        try {
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            return res.getEntity().getContent();
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse deleteTestScriptRun(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_DELETE.replace("!id", String.valueOf(id));
        return this.getXmlResponse(url);
    }

    public XmlResponse setSfCurrentID(int id, long sfCurrentID) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_UPDATE.replace("!id", String.valueOf(id)).replace("!sfCurrentID", String.valueOf(sfCurrentID));
        return this.getXmlResponse(url);
    }

    public XmlResponse compileTestScriptRun(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_COMPILE.replace("!id", String.valueOf(id));
        return this.getXmlResponse(url);
    }

    public XmlResponse runCompiledTestScript(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_RUN_COMPILED_SCRIPT.replace("!id", String.valueOf(id));
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteTestScriptRun(TestScriptRun run) throws APICallException, APIResponseException {
        return this.deleteTestScriptRun(run.getId());
    }

    public XmlResponse deleteAllTestScriptRun() throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_DELETE_ALL;
        return this.getXmlResponse(url);
    }

    public XmlResponse stopTestScriptRun(int id) throws APICallException, APIResponseException {
        String url = TEST_SCRIPT_RUN_STOP.replace("!id", String.valueOf(id));
        return this.getXmlResponse(url);
    }

    public XmlResponse stopTestScriptRun(TestScriptRun run) throws APICallException, APIResponseException {
        return this.stopTestScriptRun(run.getId());
    }

    public List<String> getEnvironmentList() throws APICallException, APIResponseException {
        Document doc = this.getDocument(ENVIRONMENTS);
        ArrayList<String> list = new ArrayList<String>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            list.add(n.getTextContent());
        }
        return list;
    }

    public XmlResponse createEnvironment(String name) throws APICallException, APIResponseException {
        String url = ENVIRONMENT_CREATE.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse deleteEnvironment(String name) throws APICallException, APIResponseException {
        String url = ENVIRONMENT_DELETE.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse renameEnvironment(String oldName, String newName) throws APICallException, APIResponseException {
        String url = ENVIRONMENT_RENAME.replace("!old", oldName).replace("!new", newName);
        return this.getXmlResponse(url);
    }

    public XmlResponse getEnvironmentVariableSet(String name) throws APIResponseException, APICallException {
        logger.debug("Sending request to get variable set for environment '{}' to: {}", (Object)name, (Object)this.rootUrl);
        String url = ENVIRONMENT_GET_VARIABLE_SET.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse setEnvironmentVariableSet(String environmentName, String variableSetName) throws APIResponseException, APICallException {
        logger.debug("Sending request to set variable set for environment '{}' to '{}' to: {}", new Object[]{environmentName, variableSetName, this.rootUrl});
        String url = ENVIRONMENT_SET_VARIABLE_SET.replace("!name", environmentName).replace("!set", Objects.toString(variableSetName, ""));
        return this.getXmlResponse(url);
    }

    public Set<String> getVariableSets() throws APIResponseException, APICallException {
        logger.debug("Sending request to get variable sets from: {}", (Object)this.rootUrl);
        return this.getResponse(VARIABLE_SETS, XmlVariableSets.class).getVariableSets();
    }

    public XmlResponse deleteVariableSet(String name) throws APIResponseException, APICallException {
        logger.debug("Sending request to delete variable set '{}' from '{}'", (Object)name, (Object)this.rootUrl);
        String url = VARIABLE_SET_DELETE.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlVariableSets importVariableSets(String fileName, InputStream data, boolean replaceExisting) throws APIResponseException, APICallException {
        XmlVariableSets xmlVariableSets;
        block9: {
            logger.debug("Importing variable sets from file '{}' to '{}' with replace existing set to '{}'", new Object[]{fileName, this.rootUrl, replaceExisting});
            String url = this.rootUrl + VARIABLE_SETS_IMPORT.replace("!re", String.valueOf(replaceExisting));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().addBinaryBody("file", data, ContentType.APPLICATION_OCTET_STREAM, fileName);
            HttpPost request = new HttpPost(url);
            request.setEntity(builder.build());
            CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);
            try {
                this.checkHttpResponse(response);
                xmlVariableSets = this.unmarshal(XmlVariableSets.class, (HttpResponse)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (APIResponseException e) {
                    throw new APIResponseException("URL: " + url, e);
                }
                catch (Exception e) {
                    throw new APICallException(e);
                }
            }
            response.close();
        }
        return xmlVariableSets;
    }

    public void setLoggingConfiguration(File cfgFile) throws APICallException, APIResponseException {
        String url = this.rootUrl + LOGGING_CONFIGURATION;
        try {
            HttpEntity cfgEntity = MultipartEntityBuilder.create().addBinaryBody("file", cfgFile, ContentType.TEXT_PLAIN, cfgFile.getName()).build();
            HttpUriRequest request = RequestBuilder.post((String)url).setEntity(cfgEntity).build();
            try (CloseableHttpResponse response = this.http.execute(request);){
                this.checkHttpResponse(response);
            }
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public InputStream getLoggingConfiguration() throws APIResponseException, APICallException {
        String url = this.rootUrl + LOGGING_CONFIGURATION;
        try {
            CloseableHttpResponse response = this.http.execute((HttpUriRequest)new HttpGet(url));
            this.checkHttpResponse(response);
            return response.getEntity().getContent();
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse registerTag(String name) throws APICallException, APIResponseException {
        String url = STATS_REGISTER_TAG.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse registerTagGroup(String name) throws APICallException, APIResponseException {
        String url = STATS_REGISTER_GROUP.replace("!name", name);
        return this.getXmlResponse(url);
    }

    public XmlResponse registerTagInGroup(String tag, String group) throws APICallException, APIResponseException {
        String url = STATS_REGISTER_TAG_IN_GROUP.replace("!tag", tag).replace("!group", group);
        return this.getXmlResponse(url);
    }

    public XmlResponse setStatisticsDBSettings(String xmlConfig) throws APICallException, APIResponseException {
        String url = this.rootUrl + "statistics/set_db_settings";
        try {
            HttpPost req = new HttpPost(url);
            req.setHeader("Content-Type", "application/xml");
            req.setEntity((HttpEntity)new StringEntity(xmlConfig));
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            XmlResponse xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
            res.close();
            return xmlResponse;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse cleanResources(Instant olderthan, String ... targets) throws APICallException, APIResponseException {
        String url = this.rootUrl + RESOURCES_CLEAN_OLDERTHAN_TARGETS.replace("!olderthan", olderthan.toString()).replace("!targets", String.join((CharSequence)",", targets));
        try {
            HttpDelete req = new HttpDelete(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            XmlResponse xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
            res.close();
            return xmlResponse;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse cleanResources(String ... targets) throws APICallException, APIResponseException {
        String url = this.rootUrl + RESOURCES_CLEAN_TARGETS.replace("!targets", String.join((CharSequence)",", targets));
        try {
            HttpDelete req = new HttpDelete(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            XmlResponse xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
            res.close();
            return xmlResponse;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public XmlResponse cleanResources(Instant olderthan) throws APICallException, APIResponseException {
        String url = this.rootUrl + RESOURCES_CLEAN_OLDERTHAN.replace("!olderthan", olderthan.toString());
        try {
            HttpDelete req = new HttpDelete(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            XmlResponse xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
            res.close();
            return xmlResponse;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public String getUID() throws APIResponseException, APICallException {
        try {
            XmlInfoSFStatus response = this.getResponse(CONFIG_STATUS, XmlInfoSFStatus.class);
            return response.getCore().getUid();
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: config/status", e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.docBuilder;
    }

    @Override
    public void close() throws IOException {
        this.http.close();
    }

    private CloseableHttpResponse getHttpResponse(String relativeUrl) throws APICallException, APIResponseException {
        String urlString = this.rootUrl + relativeUrl;
        try {
            logger.debug("Request: {}", (Object)urlString);
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            HttpGet req = new HttpGet(uri);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            return res;
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + urlString + " Message: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    private void checkHttpResponse(CloseableHttpResponse res) throws IOException, JAXBException, APIResponseException {
        if (res.getStatusLine().getStatusCode() != 200) {
            XmlResponse xmlResponse = null;
            try {
                xmlResponse = this.unmarshal(XmlResponse.class, (HttpResponse)res);
            }
            catch (UnmarshalException e) {
                xmlResponse = new XmlResponse();
            }
            throw new APIResponseException("Message: " + xmlResponse.getMessage() + "; Cause: " + xmlResponse.getRootCause() + "; Http status: " + res.getStatusLine().getStatusCode());
        }
    }

    private <T> T getResponse(String url, Class<T> clazz) throws APICallException, APIResponseException {
        CloseableHttpResponse response = this.getHttpResponse(url);
        try {
            T xmlResponse = this.unmarshal(clazz, (HttpResponse)response);
            response.close();
            return xmlResponse;
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }

    private XmlResponse getXmlResponse(String url) throws APICallException, APIResponseException {
        XmlResponse xmlResponse = this.getResponse(url, XmlResponse.class);
        if (xmlResponse == null) {
            xmlResponse = new XmlResponse();
            xmlResponse.setMessage("No data received");
        }
        return xmlResponse;
    }

    private Unmarshaller getUnmarshaller(Class<?> clazz) throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshallers.get(clazz);
        if (unmarshaller != null) {
            return unmarshaller;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        unmarshaller = jaxbContext.createUnmarshaller();
        this.unmarshallers.put(clazz, unmarshaller);
        return unmarshaller;
    }

    private <T> T unmarshal(Class<T> clazz, HttpResponse response) throws JAXBException, IOException {
        if (response != null) {
            Unmarshaller unmarshaller = this.getUnmarshaller(clazz);
            StreamSource streamSource = new StreamSource(response.getEntity().getContent());
            JAXBElement unmarshalledElement = unmarshaller.unmarshal((Source)streamSource, clazz);
            return (T)unmarshalledElement.getValue();
        }
        return null;
    }

    private Document getDocument(String relativeUrl) throws APICallException, APIResponseException {
        String url = this.rootUrl + relativeUrl;
        try {
            logger.debug("Request: {}", (Object)url);
            HttpGet req = new HttpGet(url);
            CloseableHttpResponse res = this.http.execute((HttpUriRequest)req);
            this.checkHttpResponse(res);
            InputStream content = res.getEntity() != null ? res.getEntity().getContent() : null;
            Document result = content != null ? this.docBuilder.parse(content) : null;
            res.close();
            return result;
        }
        catch (APIResponseException e) {
            throw new APIResponseException("URL: " + url, e);
        }
        catch (Exception e) {
            throw new APICallException(e);
        }
    }
}

