/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtil {
    private static final Logger logger = LoggerFactory.getLogger(SerializeUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserializeBase64Obj(String encodedCause, Class<T> clazz) {
        if (encodedCause == null) {
            return null;
        }
        byte[] data = DatatypeConverter.parseBase64Binary((String)encodedCause);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object o = ois.readObject();
            T t = clazz.cast(o);
            return t;
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("Object deserializing error", (Throwable)e);
            return null;
        }
    }

    public static String serializeToBase64(Serializable o) {
        String string;
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
            }
            string = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("Object serializing error", (Throwable)e);
                return null;
            }
        }
        baos.close();
        return string;
    }
}

