/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf;

import com.exactpro.sf.ServiceDescriptor;
import com.exactpro.sf.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Service {
    private final Map<String, String> settings = new HashMap<String, String>();
    private String name;
    private Status status;
    private String type;
    private String serviceHandlerClassName;
    private String settingsTag;

    public String getName() {
        return this.name;
    }

    protected void setName(String value) {
        this.name = value;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String value) {
        this.type = value;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status value) {
        this.status = value;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getServiceHandlerClassName() {
        return this.serviceHandlerClassName;
    }

    protected void setServiceHandlerClassName(String serviceHandlerClassName) {
        this.serviceHandlerClassName = serviceHandlerClassName;
    }

    public String getSettingsTag() {
        return this.settingsTag;
    }

    protected void setSettingsTag(String settingsTag) {
        this.settingsTag = settingsTag;
    }

    protected void write(OutputStream out, DocumentBuilder builder, Transformer transformer) throws IOException, TransformerException {
        if (this.type == null || this.name == null || this.serviceHandlerClassName == null || this.settingsTag == null) {
            throw new RuntimeException("Could not write service: some of required fields are empty");
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("serviceDescription");
        doc.appendChild(root);
        Element ch = doc.createElement("type");
        ch.setTextContent(this.getType());
        root.appendChild(ch);
        ch = doc.createElement("name");
        ch.setTextContent(this.getName());
        root.appendChild(ch);
        ch = doc.createElement("serviceHandlerClassName");
        ch.setTextContent(this.serviceHandlerClassName);
        root.appendChild(ch);
        ch = doc.createElement(this.settingsTag);
        for (Map.Entry<String, String> e : this.settings.entrySet()) {
            Element el = doc.createElement(e.getKey());
            el.setTextContent(e.getValue());
            ch.appendChild(el);
        }
        root.appendChild(ch);
        DOMSource src = new DOMSource(doc);
        StreamResult dest = new StreamResult(out);
        transformer.transform(src, dest);
    }

    protected static Service fromXml(Node n) {
        Element el = (Element)n;
        Service svc = new Service();
        svc.setName(Util.getTextContent(el, "serviceName"));
        svc.setType(Util.getTextContent(el, "type"));
        svc.setStatus(Enum.valueOf(Status.class, Util.getTextContent(el, "status")));
        NodeList settings = el.getElementsByTagName("settings").item(0).getChildNodes();
        for (int j = 0; j < settings.getLength(); ++j) {
            Node z = settings.item(j);
            svc.getSettings().put(z.getNodeName(), z.getTextContent());
        }
        return svc;
    }

    protected static Service fromXml(Node n, String serviceHandlerClassName) {
        Service svc = Service.fromXml(n);
        svc.serviceHandlerClassName = serviceHandlerClassName;
        return svc;
    }

    public static Service fromDescriptor(ServiceDescriptor des, String name) {
        Service svc = new Service();
        svc.setName(name);
        svc.setType(des.getName());
        svc.setServiceHandlerClassName("com.exactpro.sf.services.CollectorServiceHandler");
        svc.setSettingsTag(des.getSettingsTagName());
        return svc;
    }

    public static enum Status {
        OK,
        CREATING,
        CREATED,
        INITIALIZING,
        INITIALIZED,
        STARTING,
        STARTED,
        DISPOSING,
        DISPOSED,
        WARNING,
        ERROR,
        DISABLED;

    }
}

