/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf;

import com.exactpro.sf.ServiceDescriptor;
import com.exactpro.sf.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServiceDescriptors {
    private final Map<String, ServiceDescriptor> descriptors = new HashMap<String, ServiceDescriptor>();
    private static ServiceDescriptors instance;

    private ServiceDescriptors() {
    }

    public ServiceDescriptor get(String name) {
        return this.descriptors.get(name);
    }

    public static void init(DocumentBuilder db) throws IOException, SAXException {
        ServiceDescriptors tmp = new ServiceDescriptors();
        Document doc = db.parse(ServiceDescriptors.class.getClassLoader().getResourceAsStream("xml/cfg/descriptor.xml"));
        Element el = doc.getDocumentElement();
        el = (Element)el.getElementsByTagName("Descriptions").item(0);
        el = (Element)el.getElementsByTagName("Services").item(0);
        NodeList svcs = el.getElementsByTagName("Service");
        for (int i = 0; i < svcs.getLength(); ++i) {
            el = (Element)svcs.item(i);
            String name = el.getAttribute("name");
            String className = Util.getTextContent(el, "className");
            String settingsClassName = Util.getTextContent(el, "settingsClassName");
            tmp.descriptors.put(name, new ServiceDescriptor(name, className, settingsClassName));
        }
        instance = tmp;
    }

    public static ServiceDescriptors getInstance() {
        return instance;
    }

    public static ServiceDescriptor forName(String name) {
        return instance == null ? null : instance.get(name);
    }
}

