/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf.configuration.suri;

import com.exactpro.sf.common.util.EPSCommonException;
import com.exactpro.sf.configuration.suri.SailfishURIException;
import com.exactpro.sf.configuration.suri.SailfishURIRule;
import com.exactpro.sf.configuration.suri.SailfishURIUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SailfishURI
implements Comparable<SailfishURI>,
Serializable {
    private static final long serialVersionUID = -7920972587219368580L;
    private static final String URI_REGEX = "^(?!$)((?<pluginAlias>\\w+)\\:)?((?<classAlias>\\w+)\\.)?(?<resourceName>\\w+)?$";
    private static final Pattern URI_PATTERN = Pattern.compile("^(?!$)((?<pluginAlias>\\w+)\\:)?((?<classAlias>\\w+)\\.)?(?<resourceName>\\w+)?$");
    private final String pluginAlias;
    private final String classAlias;
    private final String resourceName;
    @JsonIgnore
    private final int hashPluginAlias;
    @JsonIgnore
    private final int hashClassAlias;
    @JsonIgnore
    private final int hashResourceName;

    public SailfishURI(String pluginAlias) throws SailfishURIException {
        this(pluginAlias, null);
    }

    public SailfishURI(String pluginAlias, String classAlias) throws SailfishURIException {
        this(pluginAlias, classAlias, null);
    }

    @JsonCreator
    public SailfishURI(@JsonProperty(value="pluginAlias") String pluginAlias, @JsonProperty(value="classAlias") String classAlias, @JsonProperty(value="resourceName") String resourceName) throws SailfishURIException {
        if (pluginAlias == null && classAlias == null && resourceName == null) {
            throw new SailfishURIException("At least one argument must not be null");
        }
        this.pluginAlias = this.validateElement(pluginAlias);
        this.classAlias = this.validateElement(classAlias);
        this.resourceName = this.validateElement(resourceName);
        this.hashPluginAlias = this.getHash(this.pluginAlias);
        this.hashClassAlias = this.getHash(this.classAlias);
        this.hashResourceName = this.getHash(this.resourceName);
    }

    public static SailfishURI parse(String uri) throws SailfishURIException {
        return SailfishURI.parse(uri, SailfishURIRule.REQUIRE_RESOURCE, new SailfishURIRule[0]);
    }

    public static SailfishURI parse(String uri, SailfishURIRule defaultRule, SailfishURIRule ... rules) throws SailfishURIException {
        if (uri == null) {
            return null;
        }
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            try {
                SailfishURI result = new SailfishURI(matcher.group("pluginAlias"), matcher.group("classAlias"), matcher.group("resourceName"));
                return SailfishURIUtils.checkURI(result, defaultRule, rules);
            }
            catch (SailfishURIException e) {
                throw new SailfishURIException("Invalid URI: " + uri, e);
            }
        }
        throw new SailfishURIException("Invalid URI: " + uri);
    }

    public static SailfishURI unsafeParse(String uri) {
        try {
            return SailfishURI.parse(uri);
        }
        catch (SailfishURIException e) {
            throw new EPSCommonException(e);
        }
    }

    public SailfishURI merge(SailfishURI uri) throws SailfishURIException {
        Objects.requireNonNull(uri, "URI cannot be null");
        return new SailfishURI((String)ObjectUtils.defaultIfNull((Object)this.pluginAlias, (Object)uri.pluginAlias), (String)ObjectUtils.defaultIfNull((Object)this.classAlias, (Object)uri.classAlias), (String)ObjectUtils.defaultIfNull((Object)this.resourceName, (Object)uri.resourceName));
    }

    public boolean matches(SailfishURI uri) {
        return uri != null && this.matchElements(this.pluginAlias, uri.pluginAlias, this.hashPluginAlias, uri.hashPluginAlias) && this.matchElements(this.classAlias, uri.classAlias, this.hashClassAlias, uri.hashClassAlias) && this.matchElements(this.resourceName, uri.resourceName, this.hashResourceName, uri.hashResourceName);
    }

    public String getPluginAlias() {
        return this.pluginAlias;
    }

    public String getClassAlias() {
        return this.classAlias;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    @JsonIgnore
    public boolean isAbsolute() {
        return this.pluginAlias != null && this.classAlias != null && this.resourceName != null;
    }

    private String validateElement(String element) throws SailfishURIException {
        if (element == null || SourceVersion.isIdentifier(element)) {
            return element;
        }
        throw new SailfishURIException("Invalid URI element: " + element);
    }

    private boolean matchElements(String element1, String element2, int hash1, int hash2) {
        return element1 == null || element2 == null || hash1 == hash2 && element1.equalsIgnoreCase(element2);
    }

    private int getHash(String value) {
        return value != null ? value.toLowerCase().hashCode() : 0;
    }

    @Override
    public int compareTo(SailfishURI o) {
        if (o == null) {
            return 1;
        }
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)this.pluginAlias, (Object)o.pluginAlias, String.CASE_INSENSITIVE_ORDER);
        builder.append((Object)this.classAlias, (Object)o.classAlias, String.CASE_INSENSITIVE_ORDER);
        builder.append((Object)this.resourceName, (Object)o.resourceName, String.CASE_INSENSITIVE_ORDER);
        return builder.toComparison();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SailfishURI)) {
            return false;
        }
        SailfishURI that = (SailfishURI)o;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)StringUtils.lowerCase((String)this.pluginAlias), (Object)StringUtils.lowerCase((String)that.pluginAlias));
        builder.append((Object)StringUtils.lowerCase((String)this.classAlias), (Object)StringUtils.lowerCase((String)that.classAlias));
        builder.append((Object)StringUtils.lowerCase((String)this.resourceName), (Object)StringUtils.lowerCase((String)that.resourceName));
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)StringUtils.lowerCase((String)this.pluginAlias));
        builder.append((Object)StringUtils.lowerCase((String)this.classAlias));
        builder.append((Object)StringUtils.lowerCase((String)this.resourceName));
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.pluginAlias != null) {
            builder.append(this.pluginAlias);
            builder.append(':');
        }
        if (this.classAlias != null) {
            builder.append(this.classAlias);
            builder.append('.');
        }
        if (this.resourceName != null) {
            builder.append(this.resourceName);
        }
        return builder.toString();
    }
}

