/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.sf.configuration.suri;

import com.exactpro.sf.configuration.suri.SailfishURI;
import com.exactpro.sf.configuration.suri.SailfishURIRule;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailfishURIUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SailfishURIUtils.class);

    public static SailfishURI getMatchingURI(SailfishURI uri, Set<SailfishURI> set, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(set, "set cannot be null");
        SailfishURIUtils.checkURI(uri, defaultRule, rules);
        for (SailfishURI sailfishURI : set) {
            if (!uri.matches(sailfishURI)) continue;
            LOGGER.debug("Matching: {} -> {}", (Object)uri, (Object)sailfishURI);
            return sailfishURI;
        }
        return null;
    }

    public static SailfishURI getSingleMatchingURI(SailfishURI uri, Set<SailfishURI> set, String resource, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(set, "set cannot be null");
        SailfishURIUtils.checkURI(uri, defaultRule, rules);
        ArrayList<SailfishURI> matchingUris = new ArrayList<SailfishURI>();
        for (SailfishURI sailfishUri : set) {
            if (!uri.matches(sailfishUri)) continue;
            matchingUris.add(sailfishUri);
        }
        if (matchingUris.isEmpty()) {
            throw new NoSuchElementException("No " + resource + " with URI matching: " + uri);
        }
        if (matchingUris.size() > 1) {
            throw new IllegalArgumentException("More than one " + resource + " with URI matching '" + uri + "': " + matchingUris);
        }
        return (SailfishURI)matchingUris.get(0);
    }

    public static <T> T getMatchingValue(SailfishURI uri, Multimap<SailfishURI, T> multimap, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(multimap, "multimap cannot be null");
        SailfishURIUtils.checkURI(uri, defaultRule, rules);
        Collection c = (Collection)SailfishURIUtils.getMatchingValue(uri, multimap.asMap(), defaultRule, rules);
        return c == null || c.isEmpty() ? null : (T)c.iterator().next();
    }

    public static <T> T getMatchingValue(SailfishURI uri, Map<SailfishURI, T> map, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(map, "map cannot be null");
        SailfishURI key = SailfishURIUtils.getMatchingURI(uri, map.keySet(), defaultRule, rules);
        return key != null ? (T)map.get(key) : null;
    }

    public static <T> Set<T> getMatchingValues(SailfishURI uri, Multimap<SailfishURI, T> multimap, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(multimap, "multimap cannot be null");
        SailfishURIUtils.checkURI(uri, defaultRule, rules);
        HashSet values = new HashSet();
        for (Collection c : SailfishURIUtils.getMatchingValues(uri, multimap.asMap(), defaultRule, rules)) {
            values.addAll(c);
        }
        return values;
    }

    public static <T> Set<T> getMatchingValues(SailfishURI uri, Map<SailfishURI, T> map, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(map, "map cannot be null");
        SailfishURIUtils.checkURI(uri, defaultRule, rules);
        HashSet<T> values = new HashSet<T>();
        for (SailfishURI key : map.keySet()) {
            if (!uri.matches(key)) continue;
            LOGGER.debug("Matching: {} -> {}", (Object)uri, (Object)key);
            values.add(map.get(key));
        }
        return values;
    }

    public static SailfishURI checkURI(SailfishURI uri, SailfishURIRule defaultRule, SailfishURIRule ... rules) {
        Objects.requireNonNull(uri, "uri cannot be null");
        Objects.requireNonNull(defaultRule, "defaultRule cannot be null");
        Objects.requireNonNull(rules, "rules cannot be null");
        for (SailfishURIRule rule : (SailfishURIRule[])ArrayUtils.add((Object[])rules, (Object)((Object)defaultRule))) {
            if (rule.check(uri)) continue;
            throw new IllegalArgumentException(String.format("Invalid URI: %s (%s)", uri, rule.getDescription()));
        }
        return uri;
    }

    public static String sanitize(String value) {
        return value != null ? value.replaceAll("[^\\w:.]", "_") : null;
    }
}

