/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exsol.errorcodemodel.ErrorCodeParser;
import java.util.Objects;

public class ErrorIdentifier {
    private final Type type;
    private final String tag;
    private final int index;

    public ErrorIdentifier(Type type, String tag, int index) {
        this.type = type;
        this.tag = tag;
        this.index = index;
    }

    public static ErrorIdentifier parse(String errorCode) throws SyntaxException {
        return new ErrorCodeParser().parse(errorCode);
    }

    public Type getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tag, this.index});
    }

    public String toString() {
        return this.type.toString() + "-" + this.getTag() + "-" + this.getIndex();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorIdentifier)) {
            return false;
        }
        ErrorIdentifier errorCode = (ErrorIdentifier)other;
        return this.index == errorCode.index && this.type == errorCode.type && Objects.equals(this.tag, errorCode.tag);
    }

    public static class SyntaxException
    extends Exception {
        public SyntaxException(String message) {
            super(message);
        }

        public SyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum Type {
        E,
        F,
        W;

    }
}

