/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exsol.errorcodemodel.NamedParameter;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class ErrorMessageDeclaration {
    private final String identifier;
    private final String message;
    private final String sourceFile;
    private final int line;
    private final String declaringPackage;
    private final List<String> mitigations;
    private final List<NamedParameter> namedParameters;

    private ErrorMessageDeclaration(Builder builder) {
        this.identifier = builder.identifier;
        this.message = builder.messageBuilder.toString();
        this.sourceFile = builder.sourceFile;
        this.declaringPackage = builder.declaringPackage;
        this.line = builder.line;
        this.mitigations = builder.mitigations;
        this.namedParameters = builder.namedParameters;
    }

    public ErrorMessageDeclaration withoutSourcePosition() {
        return this.withSourceFile(null).withLine(-1);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public String getDeclaringPackage() {
        return this.declaringPackage;
    }

    @Generated
    public List<String> getMitigations() {
        return this.mitigations;
    }

    @Generated
    public List<NamedParameter> getNamedParameters() {
        return this.namedParameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessageDeclaration)) {
            return false;
        }
        ErrorMessageDeclaration other = (ErrorMessageDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$sourceFile = this.getSourceFile();
        String other$sourceFile = other.getSourceFile();
        if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
            return false;
        }
        String this$declaringPackage = this.getDeclaringPackage();
        String other$declaringPackage = other.getDeclaringPackage();
        if (this$declaringPackage == null ? other$declaringPackage != null : !this$declaringPackage.equals(other$declaringPackage)) {
            return false;
        }
        List<String> this$mitigations = this.getMitigations();
        List<String> other$mitigations = other.getMitigations();
        if (this$mitigations == null ? other$mitigations != null : !((Object)this$mitigations).equals(other$mitigations)) {
            return false;
        }
        List<NamedParameter> this$namedParameters = this.getNamedParameters();
        List<NamedParameter> other$namedParameters = other.getNamedParameters();
        return !(this$namedParameters == null ? other$namedParameters != null : !((Object)this$namedParameters).equals(other$namedParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessageDeclaration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $sourceFile = this.getSourceFile();
        result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
        String $declaringPackage = this.getDeclaringPackage();
        result = result * 59 + ($declaringPackage == null ? 43 : $declaringPackage.hashCode());
        List<String> $mitigations = this.getMitigations();
        result = result * 59 + ($mitigations == null ? 43 : ((Object)$mitigations).hashCode());
        List<NamedParameter> $namedParameters = this.getNamedParameters();
        result = result * 59 + ($namedParameters == null ? 43 : ((Object)$namedParameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorMessageDeclaration(identifier=" + this.getIdentifier() + ", message=" + this.getMessage() + ", sourceFile=" + this.getSourceFile() + ", line=" + this.getLine() + ", declaringPackage=" + this.getDeclaringPackage() + ", mitigations=" + this.getMitigations() + ", namedParameters=" + this.getNamedParameters() + ")";
    }

    @Generated
    private ErrorMessageDeclaration(String identifier, String message, String sourceFile, int line, String declaringPackage, List<String> mitigations, List<NamedParameter> namedParameters) {
        this.identifier = identifier;
        this.message = message;
        this.sourceFile = sourceFile;
        this.line = line;
        this.declaringPackage = declaringPackage;
        this.mitigations = mitigations;
        this.namedParameters = namedParameters;
    }

    @Generated
    private ErrorMessageDeclaration withSourceFile(String sourceFile) {
        return this.sourceFile == sourceFile ? this : new ErrorMessageDeclaration(this.identifier, this.message, sourceFile, this.line, this.declaringPackage, this.mitigations, this.namedParameters);
    }

    @Generated
    private ErrorMessageDeclaration withLine(int line) {
        return this.line == line ? this : new ErrorMessageDeclaration(this.identifier, this.message, this.sourceFile, line, this.declaringPackage, this.mitigations, this.namedParameters);
    }

    public static class Builder {
        private final StringBuilder messageBuilder = new StringBuilder();
        private final List<String> mitigations = new LinkedList<String>();
        private final List<NamedParameter> namedParameters = new LinkedList<NamedParameter>();
        private String identifier;
        private String sourceFile;
        private int line = -1;
        private String declaringPackage;

        private Builder() {
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setPosition(String sourceFile, int line) {
            this.sourceFile = sourceFile;
            this.line = line;
            return this;
        }

        public Builder declaringPackage(String declaringPackage) {
            this.declaringPackage = declaringPackage;
            return this;
        }

        public Builder prependMessage(String message) {
            this.messageBuilder.insert(0, message);
            return this;
        }

        public Builder prependMitigation(String mitigation) {
            this.mitigations.add(0, mitigation);
            return this;
        }

        public Builder appendMitigation(String mitigation) {
            this.mitigations.add(mitigation);
            return this;
        }

        public Builder addParameter(String name, String description) {
            this.namedParameters.add(new NamedParameter(name, description));
            return this;
        }

        public ErrorMessageDeclaration build() {
            return new ErrorMessageDeclaration(this);
        }
    }
}

