/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exsol.errorcodemodel.NamedParameter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ErrorMessageDeclaration {
    private static final String NO_SOURCE_FILE = null;
    private static final int NO_SOURCE_LINE = -1;
    private final String identifier;
    private final String message;
    private final String sourceFile;
    private final int line;
    private final String declaringPackage;
    private final List<String> mitigations;
    private final List<NamedParameter> namedParameters;

    private ErrorMessageDeclaration(Builder builder) {
        this.identifier = builder.identifier;
        this.message = builder.messageBuilder.toString();
        this.sourceFile = builder.sourceFile;
        this.line = builder.line;
        this.declaringPackage = builder.declaringPackage;
        this.mitigations = builder.mitigations;
        this.namedParameters = builder.namedParameters;
    }

    private ErrorMessageDeclaration(String identifier, String message, String sourceFile, int line, String declaringPackage, List<String> mitigations, List<NamedParameter> namedParameters) {
        this.identifier = identifier;
        this.message = message;
        this.sourceFile = sourceFile;
        this.line = line;
        this.declaringPackage = declaringPackage;
        this.mitigations = mitigations;
        this.namedParameters = namedParameters;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public int getLine() {
        return this.line;
    }

    public String getDeclaringPackage() {
        return this.declaringPackage;
    }

    public List<String> getMitigations() {
        return this.mitigations;
    }

    public List<NamedParameter> getNamedParameters() {
        return this.namedParameters;
    }

    public ErrorMessageDeclaration withoutSourcePosition() {
        return new ErrorMessageDeclaration(this.identifier, this.message, NO_SOURCE_FILE, -1, this.declaringPackage, this.mitigations, this.namedParameters);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorMessageDeclaration that = (ErrorMessageDeclaration)other;
        return this.line == that.line && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.message, that.message) && Objects.equals(this.sourceFile, that.sourceFile) && Objects.equals(this.declaringPackage, that.declaringPackage) && Objects.equals(this.mitigations, that.mitigations) && Objects.equals(this.namedParameters, that.namedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.message, this.sourceFile, this.line, this.declaringPackage, this.mitigations, this.namedParameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final StringBuilder messageBuilder = new StringBuilder();
        private final List<String> mitigations = new LinkedList<String>();
        private final List<NamedParameter> namedParameters = new LinkedList<NamedParameter>();
        private String identifier;
        private String sourceFile = NO_SOURCE_FILE;
        private int line = -1;
        private String declaringPackage;

        private Builder() {
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setPosition(String sourceFile, int line) {
            this.sourceFile = sourceFile;
            this.line = line;
            return this;
        }

        public Builder declaringPackage(String declaringPackage) {
            this.declaringPackage = declaringPackage;
            return this;
        }

        public Builder prependMessage(String message) {
            this.messageBuilder.insert(0, message);
            return this;
        }

        public Builder prependMitigation(String mitigation) {
            this.mitigations.add(0, mitigation);
            return this;
        }

        public Builder appendMitigation(String mitigation) {
            this.mitigations.add(mitigation);
            return this;
        }

        public Builder addParameter(String name, String description) {
            this.namedParameters.add(new NamedParameter(name, description));
            return this;
        }

        public ErrorMessageDeclaration build() {
            return new ErrorMessageDeclaration(this);
        }
    }
}

