/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exasol.errorreporting.ExaError;
import com.exsol.errorcodemodel.ErrorCodeReport;
import com.exsol.errorcodemodel.ErrorMessageDeclaration;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ErrorCodeReportReader {
    private static final Set<String> SUPPORTED_SCHEMAS = Set.of("https://schemas.exasol.com/error_code_report-0.2.0.json", "https://schemas.exasol.com/error_code_report-1.0.0.json");
    private static final JsonProvider JSON = JsonProvider.provider();

    public ErrorCodeReport readReport(Path source) throws ReadException {
        JsonObject reportJson = this.readJson(source);
        this.verifySchemaIsSupported(reportJson);
        JsonArray errorCodesJson = reportJson.getJsonArray("errorCodes");
        List<ErrorMessageDeclaration> errorMessageDeclarations = this.readErrorMessageDeclarations(errorCodesJson);
        return new ErrorCodeReport(reportJson.getString("projectName", null), reportJson.getString("projectVersion", null), errorMessageDeclarations);
    }

    private List<ErrorMessageDeclaration> readErrorMessageDeclarations(JsonArray errorCodesJson) {
        ArrayList<ErrorMessageDeclaration> declarations = new ArrayList<ErrorMessageDeclaration>();
        for (JsonValue jsonValue : errorCodesJson) {
            JsonObject errorCodeJson = jsonValue.asJsonObject();
            declarations.add(this.readErrorMessageDeclaration(errorCodeJson));
        }
        return declarations;
    }

    private ErrorMessageDeclaration readErrorMessageDeclaration(JsonObject errorCodeJson) {
        ErrorMessageDeclaration.Builder errorDeclarationBuilder = ErrorMessageDeclaration.builder().identifier(errorCodeJson.getString("identifier", "")).prependMessage(errorCodeJson.getString("message", "")).setPosition(errorCodeJson.getString("sourceFile", ""), errorCodeJson.getInt("sourceLine", -1));
        this.readParameters(errorCodeJson, errorDeclarationBuilder);
        this.readMitigations(errorCodeJson, errorDeclarationBuilder);
        return errorDeclarationBuilder.build();
    }

    private void readMitigations(JsonObject errorCodeJson, ErrorMessageDeclaration.Builder errorDeclarationBuilder) {
        JsonArray mitigations = errorCodeJson.getJsonArray("mitigations");
        if (mitigations != null) {
            for (JsonValue jsonValue : mitigations) {
                JsonString mitigation = (JsonString)jsonValue;
                errorDeclarationBuilder.appendMitigation(mitigation.getString());
            }
        }
    }

    private void readParameters(JsonObject errorCodeJson, ErrorMessageDeclaration.Builder errorDeclarationBuilder) {
        JsonArray placeholdersJson = errorCodeJson.getJsonArray("messagePlaceholders");
        if (placeholdersJson != null) {
            for (JsonValue jsonValue : placeholdersJson) {
                JsonObject placeholderJson = jsonValue.asJsonObject();
                errorDeclarationBuilder.addParameter(placeholderJson.getString("placeholder", ""), placeholderJson.getString("description", ""));
            }
        }
    }

    private void verifySchemaIsSupported(JsonObject reportJson) throws ReadException {
        String schema = reportJson.getString("$schema", "");
        if (!SUPPORTED_SCHEMAS.contains(schema)) {
            throw new ReadException(ExaError.messageBuilder((String)"E-ECMOJ-3").message("Unsupported error-report schema {{schema}}.", new Object[]{schema}).mitigation("Supported schemas: {{supported schemas}}.", new Object[]{SUPPORTED_SCHEMAS}).toString());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonObject readJson(Path source) throws ReadException {
        try (FileReader fileReader = new FileReader(source.toFile());){
            JsonObject jsonObject;
            block13: {
                JsonReader reader = JSON.createReader((Reader)fileReader);
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject;
        }
        catch (IOException exception) {
            throw new ReadException(ExaError.messageBuilder((String)"E-ECMOJ-4").message("Failed to read error-code-report.", new Object[0]).toString(), exception);
        }
    }

    public static class ReadException
    extends Exception {
        private static final long serialVersionUID = -4415784194427106258L;

        public ReadException(String message) {
            super(message);
        }

        public ReadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

