/*
 * Decompiled with CFR 0.152.
 */
package com.exsol.errorcodemodel;

import com.exasol.errorreporting.ExaError;
import com.exsol.errorcodemodel.ErrorCodeReport;
import com.exsol.errorcodemodel.ErrorMessageDeclaration;
import com.exsol.errorcodemodel.NamedParameter;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.spi.JsonProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;

public class ErrorCodeReportWriter {
    public static final String SCHEMA = "https://schemas.exasol.com/error_code_report-1.0.0.json";
    private static final JsonProvider JSON = JsonProvider.provider();

    public void writeReport(ErrorCodeReport report, Path target) {
        JsonObject reportJson = this.renderReport(report);
        try (FileWriter fileWriter = new FileWriter(target.toFile());
             JsonWriter jsonWriter = JSON.createWriter((Writer)fileWriter);){
            jsonWriter.write((JsonStructure)reportJson);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ECMOJ-5").message("Failed to write error-code-report.", new Object[0]).toString(), exception);
        }
    }

    private JsonObject renderReport(ErrorCodeReport report) {
        JsonObjectBuilder reportJson = JSON.createObjectBuilder();
        reportJson.add("$schema", SCHEMA);
        if (report.getProjectName() != null) {
            reportJson.add("projectName", report.getProjectName());
        }
        if (report.getProjectVersion() != null) {
            reportJson.add("projectVersion", report.getProjectVersion());
        }
        reportJson.add("errorCodes", this.renderErrorCodes(report.getErrorMessageDeclarations()));
        return reportJson.build();
    }

    private JsonArrayBuilder renderErrorCodes(List<ErrorMessageDeclaration> errorMessageDeclarations) {
        JsonArrayBuilder errorCodesBuilder = JSON.createArrayBuilder();
        for (ErrorMessageDeclaration errorMessageDeclaration : errorMessageDeclarations) {
            errorCodesBuilder.add(this.renderErrorCode(errorMessageDeclaration));
        }
        return errorCodesBuilder;
    }

    private JsonObjectBuilder renderErrorCode(ErrorMessageDeclaration errorMessageDeclaration) {
        JsonObjectBuilder errorCode = JSON.createObjectBuilder();
        this.addIfNotNull(errorCode, "identifier", errorMessageDeclaration.getIdentifier());
        this.addIfNotNull(errorCode, "message", errorMessageDeclaration.getMessage());
        errorCode.add("messagePlaceholders", this.renderPlaceholders(errorMessageDeclaration.getNamedParameters()));
        this.addIfNotNull(errorCode, "sourceFile", errorMessageDeclaration.getSourceFile());
        if (errorMessageDeclaration.getLine() != -1) {
            errorCode.add("sourceLine", errorMessageDeclaration.getLine());
        }
        errorCode.add("mitigations", this.renderMitigations(errorMessageDeclaration));
        return errorCode;
    }

    private JsonArrayBuilder renderMitigations(ErrorMessageDeclaration errorMessageDeclaration) {
        JsonArrayBuilder mitigationsJson = JSON.createArrayBuilder();
        for (String mitigation : errorMessageDeclaration.getMitigations()) {
            mitigationsJson.add(mitigation);
        }
        return mitigationsJson;
    }

    private JsonArrayBuilder renderPlaceholders(List<NamedParameter> placeholders) {
        JsonArrayBuilder placeholdersJsonBuilder = JSON.createArrayBuilder();
        for (NamedParameter placeholder : placeholders) {
            JsonObjectBuilder placeholderJsonBuilder = JSON.createObjectBuilder();
            placeholderJsonBuilder.add("placeholder", placeholder.getName());
            this.addIfNotNull(placeholderJsonBuilder, "description", placeholder.getDescription());
            placeholdersJsonBuilder.add(placeholderJsonBuilder);
        }
        return placeholdersJsonBuilder;
    }

    private void addIfNotNull(JsonObjectBuilder builder, String key, String value) {
        if (value != null) {
            builder.add(key, value);
        }
    }
}

