/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.type;

import com.exasol.datatype.type.DataType;
import com.exasol.sql.ColumnDefinitionVisitor;

public class Decimal
implements DataType {
    private static final String NAME = "DECIMAL";
    private final int precision;
    private final int scale;

    public Decimal(int precision, int scale) {
        this.validatePrecision(precision);
        this.validateScale(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void accept(ColumnDefinitionVisitor visitor) {
        visitor.visit(this);
    }

    private void validatePrecision(int precision) {
        if (precision < 1 || precision > 36) {
            throw new IllegalArgumentException("Precision must be a number between 1 and 36.");
        }
    }

    private void validateScale(int precision, int scale) {
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("Scale must be a number between 0 and precision - 1.");
        }
    }
}

