/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.type;

import com.exasol.datatype.type.DataType;
import com.exasol.sql.ColumnDefinitionVisitor;

public class IntervalYearToMonth
implements DataType {
    private static final String NAME = "INTERVAL YEAR(%s) TO MONTH";
    private final int yearPrecision;

    public IntervalYearToMonth(int yearPrecision) {
        this.validatePrecision(yearPrecision);
        this.yearPrecision = yearPrecision;
    }

    private void validatePrecision(int yearPrecision) {
        if (yearPrecision < 1 || yearPrecision > 9) {
            throw new IllegalArgumentException("Year precision must be a number between 1 and 9.");
        }
    }

    @Override
    public void accept(ColumnDefinitionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getYearPrecision() {
        return this.yearPrecision;
    }
}

