/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.datatype.value;

import java.util.regex.Matcher;

public abstract class AbstractInterval {
    protected long value;
    protected boolean positive;

    public AbstractInterval(long value) {
        if (value >= 0L) {
            this.value = value;
            this.positive = true;
        } else {
            this.value = -value;
            this.positive = false;
        }
    }

    public AbstractInterval(long absoluteValue, boolean positive) {
        this.value = absoluteValue;
        this.positive = positive;
    }

    protected static long parseMatchingGroupToLong(Matcher matcher, int groupNumber) {
        return matcher.group(groupNumber) == null ? 0L : Long.parseLong(matcher.group(groupNumber));
    }

    protected String getSign() {
        return this.positive ? "+" : "-";
    }

    protected long getSignedValue() {
        return this.value * (long)(this.positive ? 1 : -1);
    }
}

