/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.ddl.drop;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.SqlStatement;
import com.exasol.sql.ddl.Schema;
import com.exasol.sql.ddl.drop.Cascade;
import com.exasol.sql.ddl.drop.DropSchemaFragment;
import com.exasol.sql.ddl.drop.DropSchemaVisitor;
import com.exasol.sql.ddl.drop.Restrict;

public class DropSchema
extends AbstractFragment
implements SqlStatement,
DropSchemaFragment {
    private final Schema schema;
    private Cascade cascade;
    private Restrict restrict;
    private boolean ifExists = false;

    public DropSchema(String schemaName) {
        super(null);
        this.schema = new Schema(this, schemaName);
    }

    public synchronized DropSchema ifExists() {
        if (!this.ifExists) {
            this.ifExists = true;
        }
        return this;
    }

    public synchronized void cascade() {
        this.cascade = new Cascade(this);
    }

    public synchronized void restrict() {
        this.restrict = new Restrict(this);
    }

    public String getSchemaName() {
        return this.schema.getName();
    }

    public Cascade getCascade() {
        return this.cascade;
    }

    public Restrict getRestrict() {
        return this.restrict;
    }

    public boolean hasIfExistsModifier() {
        return this.ifExists;
    }

    @Override
    public void accept(DropSchemaVisitor visitor) {
        this.validateCascadeAndRestrict();
        visitor.visit(this);
        this.schema.accept(visitor);
        if (this.cascade != null) {
            this.cascade.accept(visitor);
        }
        if (this.restrict != null) {
            this.restrict.accept(visitor);
        }
    }

    private void validateCascadeAndRestrict() {
        if (this.cascade != null && this.restrict != null) {
            throw new IllegalArgumentException("DROP SCHEMA expression must not contain CASCADE and RESTRICT clauses at the came time. Use only one of them.");
        }
    }
}

