/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dql.select;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.ColumnsDefinition;
import com.exasol.sql.DerivedColumn;
import com.exasol.sql.SqlStatement;
import com.exasol.sql.dql.select.FromClause;
import com.exasol.sql.dql.select.GroupByClause;
import com.exasol.sql.dql.select.LimitClause;
import com.exasol.sql.dql.select.OrderByClause;
import com.exasol.sql.dql.select.SelectFragment;
import com.exasol.sql.dql.select.SelectVisitor;
import com.exasol.sql.dql.select.WhereClause;
import com.exasol.sql.expression.BinaryArithmeticExpression;
import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.expression.ColumnReference;
import com.exasol.sql.expression.ExpressionTerm;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.function.Function;
import com.exasol.sql.expression.function.FunctionName;
import java.util.ArrayList;
import java.util.List;

public class Select
extends AbstractFragment
implements SqlStatement,
SelectFragment {
    private final List<DerivedColumn> derivedColumns = new ArrayList<DerivedColumn>();
    private FromClause fromClause = null;
    private WhereClause whereClause = null;
    private LimitClause limitClause = null;
    private GroupByClause groupByClause = null;
    private OrderByClause orderByClause = null;

    public Select() {
        super(null);
    }

    public Select all() {
        DerivedColumn derivedColumn = new DerivedColumn(this, ColumnReference.of("*"));
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public Select field(String ... names) {
        for (String name : names) {
            DerivedColumn derivedColumn = new DerivedColumn(this, ColumnReference.of(name));
            this.derivedColumns.add(derivedColumn);
        }
        return this;
    }

    public Select function(FunctionName functionName, ValueExpression ... valueExpressions) {
        return this.function(functionName, "", valueExpressions);
    }

    public Select function(FunctionName functionName, String derivedColumnName, ValueExpression ... valueExpressions) {
        Function function = ExpressionTerm.function(functionName, valueExpressions);
        DerivedColumn derivedColumn = new DerivedColumn(this, function, derivedColumnName);
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public Select function(Function function, String derivedColumnName) {
        DerivedColumn derivedColumn = new DerivedColumn(this, function, derivedColumnName);
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public Select function(Function function) {
        this.function(function, "");
        return this;
    }

    public Select udf(String functionName, ColumnsDefinition emitsColumnsDefinition, ValueExpression ... valueExpressions) {
        Function udf = ExpressionTerm.udf(functionName, emitsColumnsDefinition, valueExpressions);
        return this.createUdf(udf);
    }

    private Select createUdf(Function udf) {
        DerivedColumn derivedColumn = new DerivedColumn(this, udf);
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public Select udf(String functionName, ValueExpression ... valueExpressions) {
        Function udf = ExpressionTerm.udf(functionName, valueExpressions);
        return this.createUdf(udf);
    }

    @Deprecated
    public Select arithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        return this.valueExpression(arithmeticExpression);
    }

    @Deprecated
    public Select arithmeticExpression(BinaryArithmeticExpression arithmeticExpression, String derivedColumnName) {
        return this.valueExpression(arithmeticExpression, derivedColumnName);
    }

    public Select valueExpression(ValueExpression valueExpression) {
        DerivedColumn derivedColumn = new DerivedColumn(this, valueExpression);
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public Select valueExpression(ValueExpression valueExpression, String derivedColumnName) {
        DerivedColumn derivedColumn = new DerivedColumn(this, valueExpression, derivedColumnName);
        this.derivedColumns.add(derivedColumn);
        return this;
    }

    public synchronized FromClause from() {
        if (this.fromClause == null) {
            this.fromClause = new FromClause(this);
        }
        return this.fromClause;
    }

    public synchronized Select limit(int count) {
        if (this.limitClause != null) {
            throw new IllegalStateException("Tried to create a LIMIT clause in a SELECT statement that already had one.");
        }
        this.limitClause = new LimitClause(this, count);
        return this;
    }

    public synchronized Select limit(int offset, int count) {
        if (this.limitClause != null) {
            throw new IllegalStateException("Tried to create a LIMIT clause in a SELECT statement that already had one.");
        }
        this.limitClause = new LimitClause(this, offset, count);
        return this;
    }

    public synchronized Select where(BooleanExpression expression) {
        if (this.whereClause == null) {
            this.whereClause = new WhereClause(this, expression);
        }
        return this;
    }

    public synchronized GroupByClause groupBy(ColumnReference ... columnReferences) {
        if (this.groupByClause == null) {
            this.groupByClause = new GroupByClause(this, columnReferences);
        }
        return this.groupByClause;
    }

    public synchronized OrderByClause orderBy(ColumnReference ... columnReferences) {
        if (this.orderByClause == null) {
            this.orderByClause = new OrderByClause(this, columnReferences);
        }
        return this.orderByClause;
    }

    @Override
    public void accept(SelectVisitor visitor) {
        visitor.visit(this);
        for (DerivedColumn derivedColumn : this.derivedColumns) {
            derivedColumn.accept(visitor);
        }
        if (this.fromClause != null) {
            this.fromClause.accept(visitor);
        }
        if (this.whereClause != null) {
            this.whereClause.accept(visitor);
        }
        if (this.limitClause != null) {
            this.limitClause.accept(visitor);
        }
        if (this.groupByClause != null) {
            this.groupByClause.accept(visitor);
        }
        if (this.orderByClause != null) {
            this.orderByClause.accept(visitor);
        }
    }
}

