/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dql.select.rendering;

import com.exasol.sql.DerivedColumn;
import com.exasol.sql.Table;
import com.exasol.sql.ValueTable;
import com.exasol.sql.ValueTableRow;
import com.exasol.sql.dql.select.FromClause;
import com.exasol.sql.dql.select.GroupByClause;
import com.exasol.sql.dql.select.Join;
import com.exasol.sql.dql.select.JoinType;
import com.exasol.sql.dql.select.LimitClause;
import com.exasol.sql.dql.select.OrderByClause;
import com.exasol.sql.dql.select.Select;
import com.exasol.sql.dql.select.SelectVisitor;
import com.exasol.sql.dql.select.WhereClause;
import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.rendering.AbstractFragmentRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import java.util.List;

public class SelectRenderer
extends AbstractFragmentRenderer
implements SelectVisitor {
    public SelectRenderer(StringRendererConfig config) {
        super(config);
    }

    @Override
    public void visit(Select select) {
        this.appendKeyWord("SELECT ");
        this.setLastVisited(select);
    }

    @Override
    public void visit(DerivedColumn derivedColumn) {
        this.appendCommaWhenNeeded(derivedColumn);
        this.appendRenderedValueExpression(derivedColumn.getValueExpression());
        if (derivedColumn.hasDerivedColumnName()) {
            this.appendSpace();
            this.append(derivedColumn.getDerivedColumnName());
        }
        this.setLastVisited(derivedColumn);
    }

    @Override
    public void visit(FromClause fromClause) {
        this.appendKeyWord(" FROM ");
        if (fromClause.hasSubSelect()) {
            this.startParenthesis();
        }
        this.setLastVisited(fromClause);
    }

    @Override
    public void leave(FromClause fromClause) {
        if (fromClause.hasSubSelect()) {
            this.endParenthesis();
        }
        this.setLastVisited(fromClause);
    }

    @Override
    public void visit(Table table) {
        this.appendCommaWhenNeeded(table);
        this.appendAutoQuoted(table.getName());
        if (table.hasAlias()) {
            this.appendKeyWord(" AS ");
            this.append(table.getAlias());
        }
        this.setLastVisited(table);
    }

    @Override
    public void visit(Join join) {
        JoinType type = join.getType();
        if (type != JoinType.DEFAULT) {
            this.appendSpace();
            this.appendKeyWord(type.toString());
        }
        this.appendKeyWord(" JOIN ");
        this.appendAutoQuoted(join.getName());
        this.appendKeyWord(" ON ");
        this.append(join.getSpecification());
        this.setLastVisited(join);
    }

    @Override
    public void visit(WhereClause whereClause) {
        this.appendKeyWord(" WHERE ");
        this.appendRenderedValueExpression(whereClause.getExpression());
        this.setLastVisited(whereClause);
    }

    @Override
    public void visit(GroupByClause groupByClause) {
        this.appendKeyWord(" GROUP BY ");
        this.appendListOfValueExpressions(groupByClause.getColumnReferences());
        BooleanExpression having = groupByClause.getHavingBooleanExpression();
        if (having != null) {
            this.appendKeyWord(" HAVING ");
            this.appendRenderedValueExpression(having);
        }
        this.setLastVisited(groupByClause);
    }

    @Override
    public void visit(OrderByClause orderByClause) {
        Boolean nullsFirst;
        this.appendKeyWord(" ORDER BY ");
        this.appendListOfValueExpressions(orderByClause.getColumnReferences());
        Boolean desc = orderByClause.getDesc();
        if (desc != null) {
            this.appendStringDependingOnBoolean(desc, " DESC", " ASC");
        }
        if ((nullsFirst = orderByClause.getNullsFirst()) != null) {
            this.appendStringDependingOnBoolean(nullsFirst, " NULLS FIRST", " NULLS LAST");
        }
        this.setLastVisited(orderByClause);
    }

    private void appendStringDependingOnBoolean(boolean booleanValue, String string1, String string2) {
        if (booleanValue) {
            this.appendKeyWord(string1);
        } else {
            this.appendKeyWord(string2);
        }
    }

    @Override
    public void visit(LimitClause limit) {
        this.appendKeyWord(" LIMIT ");
        if (limit.hasOffset()) {
            this.append(limit.getOffset());
            this.append(", ");
        }
        this.append(limit.getCount());
        this.setLastVisited(limit);
    }

    @Override
    public void visit(ValueTable valueTable) {
        this.appendKeyWord("(VALUES ");
        this.setLastVisited(valueTable);
    }

    @Override
    public void leave(ValueTable valueTable) {
        this.endParenthesis();
        if (valueTable.hasAlias()) {
            this.appendKeyWord(" AS ");
            this.appendAutoQuoted(valueTable.getTableNameAlias());
            this.startParenthesis();
            List<String> columnNameAliases = valueTable.getColumnNameAliases();
            for (int i = 0; i < columnNameAliases.size(); ++i) {
                this.appendAutoQuoted(columnNameAliases.get(i));
                if (i >= columnNameAliases.size() - 1) continue;
                this.append(", ");
            }
            this.endParenthesis();
        }
        this.setLastVisited(valueTable);
    }

    @Override
    public void visit(ValueTableRow valueTableRow) {
        this.appendCommaWhenNeeded(valueTableRow);
        this.startParenthesis();
        this.appendValueTableRow(valueTableRow);
        this.setLastVisited(valueTableRow);
    }

    @Override
    public void leave(ValueTableRow valueTableRow) {
        this.endParenthesis();
        this.setLastVisited(valueTableRow);
    }

    public static SelectRenderer create() {
        return SelectRenderer.create(StringRendererConfig.createDefault());
    }

    public static SelectRenderer create(StringRendererConfig config) {
        return new SelectRenderer(config);
    }
}

