/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression;

import com.exasol.sql.ColumnsDefinition;
import com.exasol.sql.expression.BinaryArithmeticExpression;
import com.exasol.sql.expression.ColumnReference;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.function.Function;
import com.exasol.sql.expression.function.FunctionName;
import com.exasol.sql.expression.function.exasol.ExasolFunction;
import com.exasol.sql.expression.function.exasol.ExasolUdf;
import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.expression.literal.DoubleLiteral;
import com.exasol.sql.expression.literal.FloatLiteral;
import com.exasol.sql.expression.literal.IntegerLiteral;
import com.exasol.sql.expression.literal.LongLiteral;
import com.exasol.sql.expression.literal.NullLiteral;
import com.exasol.sql.expression.literal.StringLiteral;

public class ExpressionTerm {
    private ExpressionTerm() {
    }

    public static StringLiteral stringLiteral(String value) {
        return StringLiteral.of(value);
    }

    public static StringLiteral stringLiteral(char value) {
        return StringLiteral.of(value);
    }

    public static IntegerLiteral integerLiteral(int value) {
        return IntegerLiteral.of(value);
    }

    public static LongLiteral longLiteral(long value) {
        return LongLiteral.of(value);
    }

    public static DoubleLiteral doubleLiteral(double value) {
        return DoubleLiteral.of(value);
    }

    public static FloatLiteral floatLiteral(float value) {
        return FloatLiteral.of(value);
    }

    public static BooleanLiteral booleanLiteral(boolean value) {
        return BooleanLiteral.of(value);
    }

    public static ColumnReference column(String column) {
        return ColumnReference.of(column);
    }

    public static ColumnReference column(String table, String column) {
        return ColumnReference.column(table, column);
    }

    public static BinaryArithmeticExpression plus(ValueExpression left, ValueExpression right) {
        return BinaryArithmeticExpression.of(BinaryArithmeticExpression.BinaryArithmeticOperator.ADD, left, right);
    }

    public static BinaryArithmeticExpression minus(ValueExpression left, ValueExpression right) {
        return BinaryArithmeticExpression.of(BinaryArithmeticExpression.BinaryArithmeticOperator.SUBTRACT, left, right);
    }

    public static BinaryArithmeticExpression multiply(ValueExpression left, ValueExpression right) {
        return BinaryArithmeticExpression.of(BinaryArithmeticExpression.BinaryArithmeticOperator.MULTIPLY, left, right);
    }

    public static BinaryArithmeticExpression divide(ValueExpression left, ValueExpression right) {
        return BinaryArithmeticExpression.of(BinaryArithmeticExpression.BinaryArithmeticOperator.DIVIDE, left, right);
    }

    public static Function function(FunctionName functionName) {
        return ExasolFunction.of(functionName);
    }

    public static Function function(FunctionName functionName, ValueExpression ... valueExpressions) {
        return ExasolFunction.of(functionName, valueExpressions);
    }

    public static Function udf(String functionName, ColumnsDefinition emitsColumnsDefinition, ValueExpression ... valueExpressions) {
        return ExasolUdf.of(functionName, emitsColumnsDefinition, valueExpressions);
    }

    public static Function udf(String functionName, ValueExpression ... valueExpressions) {
        return ExasolUdf.of(functionName, valueExpressions);
    }

    public static NullLiteral nullLiteral() {
        return NullLiteral.nullLiteral();
    }
}

