/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.predicate;

import com.exasol.sql.dql.select.Select;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.predicate.AbstractPredicate;
import com.exasol.sql.expression.predicate.PredicateOperator;
import com.exasol.sql.expression.predicate.PredicateVisitor;
import java.util.Arrays;
import java.util.List;

public class InPredicate
extends AbstractPredicate {
    private final ValueExpression expression;
    private final List<ValueExpression> operands;
    private final Select selectQuery;

    private InPredicate(Builder builder) {
        super(builder.operator);
        this.expression = builder.expression;
        this.operands = builder.operands;
        this.selectQuery = builder.selectQuery;
    }

    public boolean hasSelectQuery() {
        return this.selectQuery != null;
    }

    public ValueExpression getExpression() {
        return this.expression;
    }

    public List<ValueExpression> getOperands() {
        return this.operands;
    }

    public Select getSelectQuery() {
        return this.selectQuery;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void accept(PredicateVisitor visitor) {
        visitor.visit(this);
    }

    public static class Builder {
        private ValueExpression expression;
        private List<ValueExpression> operands = null;
        private Select selectQuery = null;
        private InPredicateOperator operator = InPredicateOperator.IN;

        private Builder() {
        }

        public Builder expression(ValueExpression expression) {
            this.expression = expression;
            return this;
        }

        public Builder operands(ValueExpression ... operands) {
            if (this.selectQuery != null) {
                throw new IllegalArgumentException(this.getExceptionMessage());
            }
            this.operands = Arrays.asList(operands);
            return this;
        }

        public Builder selectQuery(Select select) {
            if (this.operands != null) {
                throw new IllegalArgumentException(this.getExceptionMessage());
            }
            this.selectQuery = select;
            return this;
        }

        private String getExceptionMessage() {
            return "The '[NOT] IN' predicate cannot have both select query and expressions. Please use only either expressions or sub select query.";
        }

        public Builder not() {
            this.operator = InPredicateOperator.NOT_IN;
            return this;
        }

        public InPredicate build() {
            return new InPredicate(this);
        }
    }

    public static enum InPredicateOperator implements PredicateOperator
    {
        IN,
        NOT_IN;


        @Override
        public String toString() {
            return super.toString().replace("_", " ");
        }
    }
}

