/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.rendering;

import com.exasol.datatype.type.AbstractStringDataType;
import com.exasol.datatype.type.Boolean;
import com.exasol.datatype.type.Char;
import com.exasol.datatype.type.DataType;
import com.exasol.datatype.type.Date;
import com.exasol.datatype.type.Decimal;
import com.exasol.datatype.type.DoublePrecision;
import com.exasol.datatype.type.IntervalDayToSecond;
import com.exasol.datatype.type.IntervalYearToMonth;
import com.exasol.datatype.type.Timestamp;
import com.exasol.datatype.type.TimestampWithLocalTimezone;
import com.exasol.datatype.type.Varchar;
import com.exasol.sql.Column;
import com.exasol.sql.ColumnDefinitionVisitor;
import com.exasol.sql.ColumnsDefinition;
import com.exasol.sql.rendering.AbstractFragmentRenderer;
import com.exasol.sql.rendering.StringRendererConfig;

public class ColumnsDefinitionRenderer
extends AbstractFragmentRenderer
implements ColumnDefinitionVisitor {
    public ColumnsDefinitionRenderer(StringRendererConfig config) {
        super(config);
    }

    @Override
    public void visit(ColumnsDefinition columnsDefinition) {
        if (!columnsDefinition.getColumns().isEmpty()) {
            this.append("(");
        }
    }

    @Override
    public void leave(ColumnsDefinition columnsDefinition) {
        if (!columnsDefinition.getColumns().isEmpty()) {
            this.append(")");
        }
        this.setLastVisited(columnsDefinition);
    }

    @Override
    public void visit(Column column) {
        this.appendCommaWhenNeeded(column);
        this.appendAutoQuoted(column.getColumnName());
        this.setLastVisited(column);
    }

    @Override
    public void visit(Char charColumn) {
        this.appendStringDataType(charColumn);
    }

    @Override
    public void visit(Varchar varcharColumn) {
        this.appendStringDataType(varcharColumn);
    }

    @Override
    public void visit(Boolean booleanColumn) {
        this.appendDataTypeWithoutParameters(booleanColumn);
    }

    @Override
    public void visit(Date dateColumn) {
        this.appendDataTypeWithoutParameters(dateColumn);
    }

    @Override
    public void visit(Decimal decimalColumn) {
        this.appendSpace();
        this.append(decimalColumn.getName());
        this.append("(");
        this.append(decimalColumn.getPrecision());
        this.append(",");
        this.append(decimalColumn.getScale());
        this.append(")");
    }

    @Override
    public void visit(DoublePrecision doublePrecisionColumn) {
        this.appendDataTypeWithoutParameters(doublePrecisionColumn);
    }

    @Override
    public void visit(Timestamp timestampColumn) {
        this.appendDataTypeWithoutParameters(timestampColumn);
    }

    @Override
    public void visit(TimestampWithLocalTimezone timestampWithLocalTimezoneColumn) {
        this.appendDataTypeWithoutParameters(timestampWithLocalTimezoneColumn);
    }

    @Override
    public void visit(IntervalDayToSecond intervalDayToSecondColumn) {
        this.appendSpace();
        this.append(this.getIntervalDayToSecondNameWithPrecision(intervalDayToSecondColumn));
    }

    @Override
    public void visit(IntervalYearToMonth intervalYearToMonthColumn) {
        this.appendSpace();
        this.append(this.getIntervalYearToMonthNameWithPrecision(intervalYearToMonthColumn));
    }

    private String getIntervalDayToSecondNameWithPrecision(IntervalDayToSecond intervalDayToSecondColumn) {
        return String.format(intervalDayToSecondColumn.getName(), intervalDayToSecondColumn.getYearPrecision(), intervalDayToSecondColumn.getMillisecondPrecision());
    }

    private String getIntervalYearToMonthNameWithPrecision(IntervalYearToMonth intervalYearToMonthColumn) {
        return String.format(intervalYearToMonthColumn.getName(), intervalYearToMonthColumn.getYearPrecision());
    }

    private void appendDataTypeWithoutParameters(DataType dataType) {
        this.appendSpace();
        this.append(dataType.getName());
    }

    private void appendStringDataType(AbstractStringDataType<? extends AbstractStringDataType<?>> stringDataType) {
        this.appendSpace();
        this.append(stringDataType.getName());
        this.append("(");
        this.append(stringDataType.getLength());
        this.append(")");
    }
}

