/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.util;

import com.exasol.sql.rendering.StringRendererConfig;

public class QuotesApplier {
    private final StringRendererConfig config;

    public QuotesApplier(StringRendererConfig config) {
        this.config = config;
    }

    public String getAutoQuoted(String identifier) {
        if (this.config.useQuotes()) {
            return this.appendQuoted(identifier);
        }
        return identifier;
    }

    private String appendQuoted(String identifier) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String part : identifier.split("\\.")) {
            if (!first) {
                stringBuilder.append(".");
            }
            this.quoteIdentifierPart(part, stringBuilder);
            first = false;
        }
        return stringBuilder.toString();
    }

    private void quoteIdentifierPart(String part, StringBuilder stringBuilder) {
        if ("*".equals(part)) {
            stringBuilder.append("*");
        } else {
            if (!part.startsWith("\"")) {
                stringBuilder.append("\"");
            }
            stringBuilder.append(part);
            if (!part.endsWith("\"")) {
                stringBuilder.append("\"");
            }
        }
    }
}

