/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dml.merge.rendering;

import com.exasol.sql.DerivedColumn;
import com.exasol.sql.Table;
import com.exasol.sql.ValueTable;
import com.exasol.sql.ValueTableRow;
import com.exasol.sql.dml.insert.InsertFields;
import com.exasol.sql.dml.merge.MatchedClause;
import com.exasol.sql.dml.merge.Merge;
import com.exasol.sql.dml.merge.MergeColumnUpdate;
import com.exasol.sql.dml.merge.MergeDeleteClause;
import com.exasol.sql.dml.merge.MergeInsertClause;
import com.exasol.sql.dml.merge.MergeUpdateClause;
import com.exasol.sql.dml.merge.MergeVisitor;
import com.exasol.sql.dml.merge.NotMatchedClause;
import com.exasol.sql.dml.merge.OnClause;
import com.exasol.sql.dml.merge.UsingClause;
import com.exasol.sql.dql.select.WhereClause;
import com.exasol.sql.rendering.AbstractFragmentRenderer;
import com.exasol.sql.rendering.StringRendererConfig;

public class MergeRenderer
extends AbstractFragmentRenderer
implements MergeVisitor {
    public MergeRenderer(StringRendererConfig config) {
        super(config);
    }

    @Override
    public void visit(Merge merge) {
        this.appendKeyWord("MERGE INTO ");
        this.setLastVisited(merge);
    }

    @Override
    public void visit(Table table) {
        this.appendAutoQuoted(table.getName());
        if (table.hasAlias()) {
            this.appendKeyWord(" AS ");
            this.append(table.getAlias());
        }
        this.setLastVisited(table);
    }

    @Override
    public void visit(UsingClause using) {
        this.appendKeyWord(" USING ");
        this.setLastVisited(using);
    }

    @Override
    public void visit(OnClause onClause) {
        this.appendKeyWord(" ON ");
        this.appendRenderedValueExpression(onClause.getCondition());
        this.setLastVisited(onClause);
    }

    @Override
    public void visit(MatchedClause matchedClause) {
        this.appendKeyWord(" WHEN MATCHED ");
        this.setLastVisited(matchedClause);
    }

    @Override
    public void visit(MergeUpdateClause mergeUpdateClause) {
        this.appendKeyWord("THEN UPDATE SET ");
        this.setLastVisited(mergeUpdateClause);
    }

    @Override
    public void visit(MergeColumnUpdate columnUpdate) {
        this.appendCommaWhenNeeded(columnUpdate);
        this.appendAutoQuoted(columnUpdate.getColumn());
        this.append(" = ");
        this.appendRenderedValueExpression(columnUpdate.getExpression());
        this.setLastVisited(columnUpdate);
    }

    @Override
    public void visit(MergeDeleteClause mergeDeleteClause) {
        this.appendKeyWord("THEN DELETE");
        this.setLastVisited(mergeDeleteClause);
    }

    @Override
    public void visit(NotMatchedClause notMatchedClause) {
        this.appendKeyWord(" WHEN NOT MATCHED ");
        this.setLastVisited(notMatchedClause);
    }

    @Override
    public void visit(MergeInsertClause mergeInsertClause) {
        this.appendKeyWord("THEN INSERT");
        this.setLastVisited(mergeInsertClause);
    }

    public static MergeRenderer create(StringRendererConfig config) {
        return new MergeRenderer(config);
    }

    public static MergeRenderer create() {
        return MergeRenderer.create(StringRendererConfig.createDefault());
    }

    @Override
    public void visit(DerivedColumn derivedColumn) {
        this.appendCommaWhenNeeded(derivedColumn);
        this.appendRenderedValueExpression(derivedColumn.getValueExpression());
        this.setLastVisited(derivedColumn);
    }

    @Override
    public void visit(InsertFields insertFields) {
        this.append(" (");
        this.setLastVisited(insertFields);
    }

    @Override
    public void leave(InsertFields insertFields) {
        this.append(")");
    }

    @Override
    public void visit(ValueTable valueTable) {
        this.appendKeyWord(" VALUES ");
        this.setLastVisited(valueTable);
    }

    @Override
    public void leave(ValueTable valueTable) {
        this.setLastVisited(valueTable);
    }

    @Override
    public void visit(ValueTableRow valueTableRow) {
        this.appendCommaWhenNeeded(valueTableRow);
        this.append("(");
        this.appendValueTableRow(valueTableRow);
        this.setLastVisited(valueTableRow);
    }

    @Override
    public void leave(ValueTableRow valueTableRow) {
        this.append(")");
        this.setLastVisited(valueTableRow);
    }

    @Override
    public void visit(WhereClause whereClause) {
        this.appendKeyWord(" WHERE ");
        this.appendRenderedValueExpression(whereClause.getExpression());
        this.setLastVisited(whereClause);
    }
}

