/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.function.exasol;

import com.exasol.sql.expression.ValueExpression;

public class WindowFrameClause {
    private WindowFrameType type;
    private WindowFrameUnitClause unit1;
    private WindowFrameUnitClause unit2;
    private WindowFrameExclusionType exclusion;

    WindowFrameClause() {
    }

    public WindowFrameClause type(WindowFrameType type) {
        this.type = type;
        return this;
    }

    public WindowFrameClause unit(UnitType unitType) {
        return this.unit(null, unitType);
    }

    public WindowFrameClause unit(ValueExpression expression, UnitType unitType) {
        this.unit1 = new WindowFrameUnitClause(unitType, expression);
        return this;
    }

    public WindowFrameClause unitBetween(UnitType unitType1, UnitType unitType2) {
        return this.unitBetween(null, unitType1, null, unitType2);
    }

    public WindowFrameClause unitBetween(ValueExpression expression1, UnitType unitType1, ValueExpression expression2, UnitType unitType2) {
        this.unit1 = new WindowFrameUnitClause(unitType1, expression1);
        this.unit2 = new WindowFrameUnitClause(unitType2, expression2);
        return this;
    }

    public WindowFrameClause exclude(WindowFrameExclusionType exclusion) {
        this.exclusion = exclusion;
        return this;
    }

    public WindowFrameType getType() {
        return this.type;
    }

    public WindowFrameUnitClause getUnit1() {
        return this.unit1;
    }

    public WindowFrameUnitClause getUnit2() {
        return this.unit2;
    }

    public WindowFrameExclusionType getExclusion() {
        return this.exclusion;
    }

    public static enum WindowFrameExclusionType {
        CURRENT_ROW("CURRENT ROW"),
        TIES("TIES"),
        GROUP("GROUP"),
        NO_OTHERS("NO OTHERS");

        private final String sqlKeyword;

        private WindowFrameExclusionType(String sqlKeyword) {
            this.sqlKeyword = sqlKeyword;
        }

        public String getSqlKeyword() {
            return this.sqlKeyword;
        }
    }

    public static class WindowFrameUnitClause {
        private final UnitType type;
        private final ValueExpression expression;

        private WindowFrameUnitClause(UnitType type, ValueExpression expression) {
            this.type = type;
            this.expression = expression;
        }

        public UnitType getType() {
            return this.type;
        }

        public ValueExpression getExpression() {
            return this.expression;
        }
    }

    public static enum UnitType {
        UNBOUNDED_PRECEEDING("UNBOUNDED PRECEEDING"),
        UNBOUNDED_FOLLOWING("UNBOUNDED FOLLOWING"),
        PRECEEDING("PRECEEDING"),
        FOLLOWING("FOLLOWING"),
        CURRENT_ROW("CURRENT ROW");

        private final String sqlKeyword;

        private UnitType(String sqlKeyword) {
            this.sqlKeyword = sqlKeyword;
        }

        public String getSqlKeyword() {
            return this.sqlKeyword;
        }
    }

    public static enum WindowFrameType {
        ROWS,
        RANGE,
        GROUPS;

    }
}

