/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.literal;

import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.expression.BooleanExpressionVisitor;
import com.exasol.sql.expression.literal.AbstractLiteral;
import com.exasol.sql.expression.literal.LiteralVisitor;

public final class BooleanLiteral
extends AbstractLiteral
implements BooleanExpression {
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private final boolean value;

    private BooleanLiteral(boolean value) {
        this.value = value;
    }

    public static BooleanLiteral of(boolean value) {
        return new BooleanLiteral(value);
    }

    public static BooleanLiteral of(String value) {
        return new BooleanLiteral(BooleanLiteral.parse(value));
    }

    private static boolean parse(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Unable to covert null value into a boolean value");
        }
        switch (value.toUpperCase()) {
            case "TRUE": 
            case "T": 
            case "Y": 
            case "YES": 
            case "ON": 
            case "ENABLED": 
            case "1": {
                return true;
            }
            case "FALSE": 
            case "F": 
            case "N": 
            case "NO": 
            case "OFF": 
            case "DISABLED": 
            case "0": {
                return false;
            }
        }
        throw new IllegalArgumentException("Unable to covert literal '" + value + "' into a boolean value");
    }

    public String toString() {
        return this.value ? TRUE : FALSE;
    }

    public boolean toBoolean() {
        return this.value;
    }

    public static BooleanExpression[] toBooleanExpressions(boolean[] values) {
        BooleanExpression[] literals = new BooleanExpression[values.length];
        for (int i = 0; i < values.length; ++i) {
            literals[i] = BooleanLiteral.of(values[i]);
        }
        return literals;
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(BooleanExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

