/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dml.merge;

import com.exasol.sql.AbstractFragment;
import com.exasol.sql.SqlStatement;
import com.exasol.sql.Table;
import com.exasol.sql.dml.merge.MatchedClause;
import com.exasol.sql.dml.merge.MergeFragment;
import com.exasol.sql.dml.merge.MergeVisitor;
import com.exasol.sql.dml.merge.NotMatchedClause;
import com.exasol.sql.dml.merge.OnClause;
import com.exasol.sql.dml.merge.UsingClause;
import com.exasol.sql.expression.BooleanExpression;

public class Merge
extends AbstractFragment
implements SqlStatement,
MergeFragment {
    private final Table destinationTable;
    private UsingClause using;
    private OnClause on;
    private MatchedClause matched;
    private NotMatchedClause notMatched;

    public Merge(String destinationTable) {
        super(null);
        this.destinationTable = new Table(this, destinationTable);
    }

    public Merge(String destinationTable, String alias) {
        super(null);
        this.destinationTable = new Table(this, destinationTable, alias);
    }

    public Merge using(String sourceTable) {
        this.using = new UsingClause(this, sourceTable);
        return this;
    }

    public Merge using(String sourceTable, String as) {
        this.using = new UsingClause(this, sourceTable, as);
        return this;
    }

    public UsingClause getUsing() {
        return this.using;
    }

    protected boolean hasUsing() {
        return this.using != null;
    }

    public Merge on(BooleanExpression condition) {
        this.on = new OnClause(this, condition);
        return this;
    }

    public OnClause getOn() {
        return this.on;
    }

    protected boolean hasOn() {
        return this.on != null;
    }

    public MatchedClause whenMatched() {
        this.matched = new MatchedClause(this);
        return this.matched;
    }

    protected boolean hasMatched() {
        return this.matched != null;
    }

    public MatchedClause getMatched() {
        return this.matched;
    }

    public NotMatchedClause whenNotMatched() {
        this.notMatched = new NotMatchedClause(this);
        return this.notMatched;
    }

    protected boolean hasNotMatched() {
        return this.notMatched != null;
    }

    public MatchedClause getNotMatched() {
        return this.matched;
    }

    @Override
    public void accept(MergeVisitor visitor) {
        visitor.visit(this);
        if (this.destinationTable != null) {
            this.destinationTable.accept(visitor);
        }
        if (this.hasUsing()) {
            this.using.accept(visitor);
        }
        if (this.hasOn()) {
            this.on.accept(visitor);
        }
        if (this.hasMatched()) {
            this.matched.accept(visitor);
        }
        if (this.hasNotMatched()) {
            this.notMatched.accept(visitor);
        }
    }
}

