/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression;

import com.exasol.sql.dql.select.Select;
import com.exasol.sql.expression.AbstractBooleanExpression;
import com.exasol.sql.expression.And;
import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.expression.Not;
import com.exasol.sql.expression.Or;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.comparison.LikeComparison;
import com.exasol.sql.expression.comparison.SimpleComparison;
import com.exasol.sql.expression.comparison.SimpleComparisonOperator;
import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.expression.predicate.BetweenPredicate;
import com.exasol.sql.expression.predicate.ExistsPredicate;
import com.exasol.sql.expression.predicate.InPredicate;
import com.exasol.sql.expression.predicate.IsNullPredicate;

public abstract class BooleanTerm
extends AbstractBooleanExpression {
    private BooleanTerm() {
    }

    public static BooleanExpression not(boolean value) {
        return new Not(value);
    }

    public static BooleanExpression not(BooleanExpression expression) {
        return new Not(expression);
    }

    public static BooleanExpression and(boolean ... values) {
        return new And(values);
    }

    public static BooleanExpression and(BooleanExpression expression, boolean value) {
        return new And(expression, BooleanLiteral.of(value));
    }

    public static BooleanExpression and(boolean value, BooleanExpression expression) {
        return new And(BooleanLiteral.of(value), expression);
    }

    public static BooleanExpression and(BooleanExpression ... expressions) {
        return new And(expressions);
    }

    public static BooleanExpression or(boolean ... values) {
        return new Or(values);
    }

    public static BooleanExpression or(BooleanExpression expression, boolean value) {
        return new Or(expression, BooleanLiteral.of(value));
    }

    public static BooleanExpression or(boolean value, BooleanExpression expression) {
        return new Or(BooleanLiteral.of(value), expression);
    }

    public static BooleanExpression or(BooleanExpression ... expressions) {
        return new Or(expressions);
    }

    public static BooleanExpression like(ValueExpression left, ValueExpression right) {
        return LikeComparison.builder().left(left).right(right).build();
    }

    public static BooleanExpression like(ValueExpression left, ValueExpression right, char escape) {
        return LikeComparison.builder().left(left).right(right).escape(escape).build();
    }

    public static BooleanExpression notLike(ValueExpression left, ValueExpression right) {
        return LikeComparison.builder().left(left).right(right).not().build();
    }

    public static BooleanExpression notLike(ValueExpression left, ValueExpression right, char escape) {
        return LikeComparison.builder().left(left).right(right).not().escape(escape).build();
    }

    public static BooleanExpression compare(ValueExpression left, String operatorSymbol, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.ofSymbol(operatorSymbol), left, right);
    }

    public static BooleanExpression compare(ValueExpression left, SimpleComparisonOperator operator, ValueExpression right) {
        return new SimpleComparison(operator, left, right);
    }

    public static BooleanExpression eq(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.EQUAL, left, right);
    }

    public static BooleanExpression ne(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.NOT_EQUAL, left, right);
    }

    public static BooleanExpression lt(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.LESS_THAN, left, right);
    }

    public static BooleanExpression gt(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.GREATER_THAN, left, right);
    }

    public static BooleanExpression le(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.LESS_THAN_OR_EQUAL, left, right);
    }

    public static BooleanExpression ge(ValueExpression left, ValueExpression right) {
        return new SimpleComparison(SimpleComparisonOperator.GREATER_THAN_OR_EQUAL, left, right);
    }

    public static BooleanExpression isNull(ValueExpression operand) {
        return new IsNullPredicate(operand);
    }

    public static BooleanExpression isNotNull(ValueExpression operand) {
        return new IsNullPredicate(IsNullPredicate.IsNullPredicateOperator.IS_NOT_NULL, operand);
    }

    public static BooleanExpression in(ValueExpression toFind, ValueExpression ... inList) {
        return InPredicate.builder().expression(toFind).operands(inList).build();
    }

    public static BooleanExpression notIn(ValueExpression toFind, ValueExpression ... inList) {
        return InPredicate.builder().expression(toFind).operands(inList).not().build();
    }

    public static BooleanExpression in(ValueExpression operand, Select select) {
        return InPredicate.builder().expression(operand).selectQuery(select).build();
    }

    public static BooleanExpression notIn(ValueExpression operand, Select select) {
        return InPredicate.builder().expression(operand).selectQuery(select).not().build();
    }

    public static BooleanExpression exists(Select select) {
        return new ExistsPredicate(select);
    }

    public static BooleanExpression between(ValueExpression expression, ValueExpression start, ValueExpression end) {
        return BetweenPredicate.builder().expression(expression).start(start).end(end).build();
    }

    public static BooleanExpression notBetween(ValueExpression expression, ValueExpression start, ValueExpression end) {
        return BetweenPredicate.builder().expression(expression).start(start).end(end).not().build();
    }

    public static BooleanExpression operation(String operator, BooleanExpression ... expressions) {
        switch (operator.toLowerCase()) {
            case "and": {
                return new And(expressions);
            }
            case "or": {
                return new Or(expressions);
            }
            case "not": {
                if (expressions.length == 1) {
                    return new Not(expressions[0]);
                }
                throw new IllegalArgumentException("Logical \"not\" must have exactly one operand. Got " + expressions.length + ".");
            }
        }
        throw new IllegalArgumentException("Unknown boolean connector \"" + operator + "\". Must be one of \"and\" or \"or\".");
    }
}

