/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.predicate;

import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.predicate.AbstractPredicate;
import com.exasol.sql.expression.predicate.PredicateOperator;
import com.exasol.sql.expression.predicate.PredicateVisitor;

public class BetweenPredicate
extends AbstractPredicate {
    private final ValueExpression expression;
    private final ValueExpression start;
    private final ValueExpression end;

    private BetweenPredicate(Builder builder) {
        super(builder.operator);
        this.expression = builder.expression;
        this.start = builder.start;
        this.end = builder.end;
    }

    public ValueExpression getExpression() {
        return this.expression;
    }

    public ValueExpression getStartExpression() {
        return this.start;
    }

    public ValueExpression getEndExpression() {
        return this.end;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void accept(PredicateVisitor visitor) {
        visitor.visit(this);
    }

    public static class Builder {
        private ValueExpression expression;
        private ValueExpression start;
        private ValueExpression end;
        private BetweenPredicateOperator operator = BetweenPredicateOperator.BETWEEN;

        private Builder() {
        }

        public Builder expression(ValueExpression expression) {
            this.expression = expression;
            return this;
        }

        public Builder start(ValueExpression start) {
            this.start = start;
            return this;
        }

        public Builder end(ValueExpression end) {
            this.end = end;
            return this;
        }

        public Builder not() {
            this.operator = BetweenPredicateOperator.NOT_BETWEEN;
            return this;
        }

        public BetweenPredicate build() {
            return new BetweenPredicate(this);
        }
    }

    public static enum BetweenPredicateOperator implements PredicateOperator
    {
        BETWEEN,
        NOT_BETWEEN;


        @Override
        public String toString() {
            return super.toString().replace("_", " ");
        }
    }
}

