/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.rendering;

import com.exasol.sql.dql.select.OrderByClause;
import com.exasol.sql.dql.select.rendering.SelectRenderer;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.function.exasol.OverClause;
import com.exasol.sql.expression.function.exasol.WindowFrameClause;
import com.exasol.sql.expression.rendering.AbstractExpressionRenderer;
import com.exasol.sql.expression.rendering.ValueExpressionRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import java.util.List;
import java.util.function.Consumer;

class OverClauseRenderer
extends AbstractExpressionRenderer {
    OverClauseRenderer(StringRendererConfig config) {
        super(config);
    }

    void visit(OverClause overClause) {
        this.append(" ");
        this.appendKeyword("OVER");
        this.append("(");
        if (overClause.getWindowName() != null) {
            this.append(overClause.getWindowName());
        }
        this.appendPartition(overClause.getPartitionByColumns());
        if (overClause.getOrderByClause() != null) {
            this.appendOrderBy(overClause.getOrderByClause());
        }
        if (overClause.getWindowFrameClause() != null) {
            this.appendWindowFrame(overClause.getWindowFrameClause());
        }
        this.append(")");
    }

    private void appendPartition(List<ValueExpression> columns) {
        if (columns == null || columns.isEmpty()) {
            return;
        }
        this.appendKeyword(" PARTITION BY ");
        this.render(renderer -> renderer.visit(columns));
    }

    private void render(Consumer<ValueExpressionRenderer> action) {
        ValueExpressionRenderer valueExpressionRenderer = new ValueExpressionRenderer(this.config);
        action.accept(valueExpressionRenderer);
        this.append(valueExpressionRenderer.render());
    }

    private void appendOrderBy(OrderByClause orderByClause) {
        SelectRenderer selectRenderer = new SelectRenderer(this.config);
        orderByClause.accept(selectRenderer);
        this.append(selectRenderer.render());
    }

    private void appendWindowFrame(WindowFrameClause windowFrameClause) {
        this.append(" ");
        WindowFrameClause.WindowFrameType type = windowFrameClause.getType();
        if (type == null) {
            throw new IllegalStateException("Type not defined. Set type the window frame.");
        }
        this.appendKeyword(type.name());
        if (windowFrameClause.getUnit1() == null) {
            throw new IllegalStateException("First unit not defined. At least one unit is required for a window frame.");
        }
        this.append(" ");
        if (windowFrameClause.getUnit2() == null) {
            this.renderUnit(windowFrameClause.getUnit1());
        } else {
            this.appendKeyword("BETWEEN ");
            this.renderUnit(windowFrameClause.getUnit1());
            this.appendKeyword(" AND ");
            this.renderUnit(windowFrameClause.getUnit2());
        }
        if (windowFrameClause.getExclusion() != null) {
            this.appendKeyword(" EXCLUDE ");
            this.appendKeyword(windowFrameClause.getExclusion().getSqlKeyword());
        }
    }

    private void renderUnit(WindowFrameClause.WindowFrameUnitClause unit) {
        if (unit.getType() == WindowFrameClause.UnitType.PRECEDING || unit.getType() == WindowFrameClause.UnitType.FOLLOWING) {
            if (unit.getExpression() == null) {
                throw new IllegalStateException("Expression is required for window frame units PRECEDING and FOLLOWING. Add expression for unit types PRECEDING and FOLLOWING.");
            }
            this.render(renderer -> renderer.visit(unit.getExpression()));
            this.append(" ");
        }
        this.appendKeyword(unit.getType().getSqlKeyword());
    }
}

