/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.expression.rendering;

import com.exasol.datatype.type.DataType;
import com.exasol.sql.ColumnsDefinition;
import com.exasol.sql.UnnamedPlaceholder;
import com.exasol.sql.dql.select.Select;
import com.exasol.sql.dql.select.rendering.SelectRenderer;
import com.exasol.sql.expression.And;
import com.exasol.sql.expression.BinaryArithmeticExpression;
import com.exasol.sql.expression.BooleanExpression;
import com.exasol.sql.expression.BooleanExpressionVisitor;
import com.exasol.sql.expression.ColumnReference;
import com.exasol.sql.expression.DefaultValue;
import com.exasol.sql.expression.Not;
import com.exasol.sql.expression.Or;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.ValueExpressionVisitor;
import com.exasol.sql.expression.comparison.Comparison;
import com.exasol.sql.expression.comparison.ComparisonVisitor;
import com.exasol.sql.expression.comparison.LikeComparison;
import com.exasol.sql.expression.comparison.SimpleComparison;
import com.exasol.sql.expression.function.AbstractFunction;
import com.exasol.sql.expression.function.Function;
import com.exasol.sql.expression.function.FunctionVisitor;
import com.exasol.sql.expression.function.exasol.AnalyticFunction;
import com.exasol.sql.expression.function.exasol.CastExasolFunction;
import com.exasol.sql.expression.function.exasol.ExasolFunction;
import com.exasol.sql.expression.function.exasol.ExasolUdf;
import com.exasol.sql.expression.function.exasol.OverClause;
import com.exasol.sql.expression.literal.BigDecimalLiteral;
import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.expression.literal.DoubleLiteral;
import com.exasol.sql.expression.literal.FloatLiteral;
import com.exasol.sql.expression.literal.IntegerLiteral;
import com.exasol.sql.expression.literal.Literal;
import com.exasol.sql.expression.literal.LiteralVisitor;
import com.exasol.sql.expression.literal.LongLiteral;
import com.exasol.sql.expression.literal.NullLiteral;
import com.exasol.sql.expression.literal.StringLiteral;
import com.exasol.sql.expression.predicate.BetweenPredicate;
import com.exasol.sql.expression.predicate.ExistsPredicate;
import com.exasol.sql.expression.predicate.InPredicate;
import com.exasol.sql.expression.predicate.IsNullPredicate;
import com.exasol.sql.expression.predicate.Predicate;
import com.exasol.sql.expression.predicate.PredicateVisitor;
import com.exasol.sql.expression.rendering.AbstractExpressionRenderer;
import com.exasol.sql.expression.rendering.OverClauseRenderer;
import com.exasol.sql.rendering.ColumnsDefinitionRenderer;
import com.exasol.sql.rendering.StringRendererConfig;
import java.util.Arrays;
import java.util.List;

public class ValueExpressionRenderer
extends AbstractExpressionRenderer
implements BooleanExpressionVisitor,
ComparisonVisitor,
FunctionVisitor,
LiteralVisitor,
PredicateVisitor,
ValueExpressionVisitor {
    int nestedLevel = 0;

    public ValueExpressionRenderer(StringRendererConfig config) {
        super(config);
    }

    @Override
    public void visit(Not not) {
        this.appendKeyword("NOT");
        this.startParenthesis();
        not.getOperand().accept(this);
        this.endParenthesis();
    }

    @Override
    public void visit(And and) {
        this.startParenthesisIfNested();
        this.append(" AND ", and.getOperands());
        this.endParenthesisIfNested();
    }

    private void append(String separator, List<BooleanExpression> expressions) {
        boolean isFirst = true;
        for (BooleanExpression expression : expressions) {
            if (!isFirst) {
                this.appendKeyword(separator);
            }
            isFirst = false;
            expression.accept(this);
        }
    }

    @Override
    public void visit(Or or) {
        this.startParenthesisIfNested();
        this.append(" OR ", or.getOperands());
        this.endParenthesisIfNested();
    }

    @Override
    public void visit(BooleanLiteral literal) {
        this.appendBooleanLiteral(literal);
    }

    @Override
    public void visit(Comparison comparison) {
        comparison.accept(this);
    }

    @Override
    public void visit(SimpleComparison simpleComparison) {
        this.openComparison(simpleComparison);
        this.closeComparison();
    }

    @Override
    public void visit(LikeComparison like) {
        this.openComparison(like);
        if (like.hasEscape()) {
            this.appendKeyword(" ESCAPE ");
            this.append("'");
            this.builder.append(like.getEscape());
            this.append("'");
        }
        this.closeComparison();
    }

    private void openComparison(Comparison comparison) {
        this.startParenthesisIfNested();
        this.appendOperand(comparison.getLeftOperand());
        this.builder.append(" ");
        this.builder.append(comparison.getOperator().toString());
        this.builder.append(" ");
        this.appendOperand(comparison.getRightOperand());
    }

    private void closeComparison() {
        this.endParenthesisIfNested();
    }

    @Override
    public void visit(Predicate predicate) {
        predicate.accept(this);
    }

    @Override
    public void visit(IsNullPredicate isNullPredicate) {
        this.startParenthesisIfNested();
        this.appendOperand(isNullPredicate.getOperand());
        this.append(" ");
        this.append(isNullPredicate.getOperator().toString());
        this.endParenthesisIfNested();
    }

    @Override
    public void visit(InPredicate inPredicate) {
        this.startParenthesisIfNested();
        this.appendOperand(inPredicate.getExpression());
        this.append(" ");
        this.append(inPredicate.getOperator().toString());
        this.append(" (");
        if (inPredicate.hasSelectQuery()) {
            this.appendSelect(inPredicate.getSelectQuery());
        } else {
            this.visit(inPredicate.getOperands());
        }
        this.append(")");
        this.endParenthesisIfNested();
    }

    @Override
    public void visit(ExistsPredicate existsPredicate) {
        this.startParenthesisIfNested();
        this.append(existsPredicate.getOperator().toString());
        this.append(" (");
        this.appendSelect(existsPredicate.getSelectQuery());
        this.append(")");
        this.endParenthesisIfNested();
    }

    @Override
    public void visit(BetweenPredicate betweenPredicate) {
        this.startParenthesisIfNested();
        this.appendOperand(betweenPredicate.getExpression());
        this.append(" ");
        this.append(betweenPredicate.getOperator().toString());
        this.append(" ");
        this.appendOperand(betweenPredicate.getStartExpression());
        this.appendKeyword(" AND ");
        this.appendOperand(betweenPredicate.getEndExpression());
        this.endParenthesisIfNested();
    }

    private void appendSelect(Select select) {
        SelectRenderer selectRenderer = SelectRenderer.create(this.config);
        select.accept(selectRenderer);
        this.append(selectRenderer.render());
    }

    public void visit(List<ValueExpression> valueExpressions) {
        boolean isFirst = true;
        for (ValueExpression parameter : valueExpressions) {
            if (!isFirst) {
                this.append(", ");
            }
            isFirst = false;
            parameter.accept(this);
        }
    }

    public void visit(ValueExpression ... valueExpressions) {
        this.visit(Arrays.asList(valueExpressions));
    }

    @Override
    public void visit(ColumnReference columnReference) {
        this.appendAutoQuoted(columnReference.toString());
    }

    @Override
    public void visit(Literal literal) {
        literal.accept(this);
    }

    @Override
    public void visit(Function function) {
        function.accept(this);
    }

    @Override
    public void visit(BooleanExpression booleanExpression) {
        booleanExpression.accept(this);
    }

    @Override
    public void visit(UnnamedPlaceholder unnamedPlaceholder) {
        this.append("?");
    }

    @Override
    public void visit(DefaultValue defaultValue) {
        this.appendKeyword("DEFAULT");
    }

    @Override
    public void visit(StringLiteral literal) {
        this.append("'");
        this.append(literal.toString());
        this.append("'");
    }

    @Override
    public void visit(IntegerLiteral literal) {
        this.append(literal.toString());
    }

    @Override
    public void visit(LongLiteral literal) {
        this.append(literal.toString());
    }

    @Override
    public void visit(DoubleLiteral literal) {
        this.append(literal.toString());
    }

    @Override
    public void visit(FloatLiteral literal) {
        this.append(literal.toString());
    }

    @Override
    public void visit(BigDecimalLiteral literal) {
        this.append(literal.toString());
    }

    @Override
    public void visit(NullLiteral nullLiteral) {
        this.appendKeyword("NULL");
    }

    @Override
    public void visit(ExasolFunction function) {
        this.renderFunction(function, null);
    }

    private void renderFunction(AbstractFunction function, AnalyticFunction.Keyword keyword) {
        this.appendKeyword(function.getFunctionName());
        if (function.hasParenthesis()) {
            this.startParenthesis();
        }
        ++this.nestedLevel;
        if (keyword != null) {
            this.appendKeyword(keyword.name());
        }
        this.visit((ValueExpression[])function.getParameters().toArray(ValueExpression[]::new));
        --this.nestedLevel;
        if (function.hasParenthesis()) {
            this.endParenthesis();
        }
    }

    @Override
    public void visit(ExasolUdf function) {
        this.renderFunction(function, null);
        this.appendEmitsWhenNecessary(function);
    }

    @Override
    public void visit(AnalyticFunction analyticFunction) {
        this.renderFunction(analyticFunction, analyticFunction.getKeyword());
        if (analyticFunction.getOverClause() != null) {
            this.renderOverClause(analyticFunction.getOverClause());
        }
    }

    private void renderOverClause(OverClause overClause) {
        OverClauseRenderer overClauseRenderer = new OverClauseRenderer(this.config);
        overClauseRenderer.visit(overClause);
        this.append(overClauseRenderer.render());
    }

    @Override
    public void visit(CastExasolFunction castFunction) {
        this.appendKeyword("CAST");
        this.startParenthesis();
        ++this.nestedLevel;
        castFunction.getValue().accept(this);
        this.appendKeyword(" AS ");
        DataType type = castFunction.getType();
        ColumnsDefinitionRenderer columnsDefinitionRenderer = this.getColumnsDefinitionRenderer();
        type.accept(columnsDefinitionRenderer);
        this.append(columnsDefinitionRenderer.render());
        --this.nestedLevel;
        this.endParenthesis();
    }

    private void appendEmitsWhenNecessary(ExasolUdf function) {
        if (function.hasEmitsColumnsDefinition()) {
            this.appendKeyword(" EMITS");
            this.append(" ");
            ColumnsDefinition columnsDefinition = function.getEmitsColumnsDefinition().get();
            ColumnsDefinitionRenderer columnsDefinitionRenderer = this.getColumnsDefinitionRenderer();
            columnsDefinition.accept(columnsDefinitionRenderer);
            this.builder.append(columnsDefinitionRenderer.render());
        }
    }

    @Override
    public void visit(BinaryArithmeticExpression expression) {
        this.startParenthesis();
        ++this.nestedLevel;
        this.appendOperand(expression.getLeft());
        this.append(expression.getStringOperatorRepresentation());
        this.appendOperand(expression.getRight());
        --this.nestedLevel;
        this.endParenthesis();
    }

    private void appendOperand(ValueExpression operand) {
        operand.accept(this);
    }

    private ColumnsDefinitionRenderer getColumnsDefinitionRenderer() {
        return new ColumnsDefinitionRenderer(this.config);
    }

    private void startParenthesisIfNested() {
        if (this.nestedLevel > 0) {
            this.startParenthesis();
        }
        ++this.nestedLevel;
    }

    private void endParenthesisIfNested() {
        --this.nestedLevel;
        if (this.nestedLevel > 0) {
            this.endParenthesis();
        }
    }
}

