/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.sql.dml.merge;

import com.exasol.sql.Fragment;
import com.exasol.sql.dml.merge.MergeColumnUpdate;
import com.exasol.sql.dml.merge.MergeFragment;
import com.exasol.sql.dml.merge.MergeMethodDefinition;
import com.exasol.sql.dml.merge.MergeVisitor;
import com.exasol.sql.expression.DefaultValue;
import com.exasol.sql.expression.ValueExpression;
import com.exasol.sql.expression.literal.BooleanLiteral;
import com.exasol.sql.expression.literal.DoubleLiteral;
import com.exasol.sql.expression.literal.FloatLiteral;
import com.exasol.sql.expression.literal.IntegerLiteral;
import com.exasol.sql.expression.literal.LongLiteral;
import com.exasol.sql.expression.literal.StringLiteral;
import java.util.ArrayList;
import java.util.List;

public class MergeUpdateClause
extends MergeMethodDefinition
implements MergeFragment {
    private final List<MergeColumnUpdate> columnUpdates = new ArrayList<MergeColumnUpdate>();

    public MergeUpdateClause(Fragment root) {
        super(root);
    }

    public MergeUpdateClause set(String column, ValueExpression expression) {
        this.columnUpdates.add(new MergeColumnUpdate(this.root, column, expression));
        return this;
    }

    public MergeUpdateClause set(String column, String literal) {
        return this.set(column, StringLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, char literal) {
        return this.set(column, StringLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, int literal) {
        return this.set(column, IntegerLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, long literal) {
        return this.set(column, LongLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, double literal) {
        return this.set(column, DoubleLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, float literal) {
        return this.set(column, FloatLiteral.of(literal));
    }

    public MergeUpdateClause set(String column, boolean literal) {
        return this.set(column, BooleanLiteral.of(literal));
    }

    public MergeUpdateClause setToDefault(String column) {
        this.columnUpdates.add(new MergeColumnUpdate(this.root, column, DefaultValue.defaultValue()));
        return this;
    }

    @Override
    public void accept(MergeVisitor visitor) {
        visitor.visit(this);
        for (MergeColumnUpdate columnUpdate : this.columnUpdates) {
            columnUpdate.accept(visitor);
        }
        if (this.hasWhere()) {
            this.where.accept(visitor);
        }
    }
}

