/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging;

import com.exasol.bucketfs.Bucket;
import com.exasol.exasoltestsetup.ExasolTestSetup;
import com.exasol.exasoltestsetup.ServiceAddress;
import com.exasol.udfdebugging.LocalServiceExposer;
import com.exasol.udfdebugging.Module;
import com.exasol.udfdebugging.ModuleFactory;
import com.exasol.udfdebugging.modules.coverage.CoverageModuleFactory;
import com.exasol.udfdebugging.modules.debugging.DebuggingModuleFactory;
import com.exasol.udfdebugging.modules.jprofiler.JProfilerModuleFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfTestSetup {
    private static final List<ModuleFactory> AVAILABLE_MODULES = List.of(new DebuggingModuleFactory(), new CoverageModuleFactory(), new JProfilerModuleFactory());
    private static final Logger LOGGER = LoggerFactory.getLogger(UdfTestSetup.class);
    private final List<Module> enabledModules = AVAILABLE_MODULES.stream().filter(ModuleFactory::isEnabled).map(moduleFactory -> moduleFactory.buildModule(localServiceExposer, bucket)).collect(Collectors.toList());

    public UdfTestSetup(String testHostIpAddress, Bucket bucket) {
        this((int port) -> new ServiceAddress(testHostIpAddress, port), bucket);
    }

    private UdfTestSetup(LocalServiceExposer localServiceExposer, Bucket bucket) {
        this.printInfoMessage();
    }

    public UdfTestSetup(ExasolTestSetup testSetup) {
        this(arg_0 -> ((ExasolTestSetup)testSetup).makeLocalTcpServiceAccessibleFromDatabase(arg_0), testSetup.getDefaultBucket());
    }

    public String[] getJvmOptions() {
        return (String[])this.enabledModules.stream().flatMap(Module::getJvmOptions).toArray(String[]::new);
    }

    private void printInfoMessage() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getInfoMessage());
        }
    }

    private String getInfoMessage() {
        StringBuilder messageBuilder = new StringBuilder("Udf Test Setup Configuration:\n");
        AVAILABLE_MODULES.forEach(module -> {
            messageBuilder.append(module.getModulePropertyName());
            messageBuilder.append(":\t");
            messageBuilder.append(module.isEnabled() ? "enabled" : "disabled");
            messageBuilder.append("\n");
        });
        return messageBuilder.toString();
    }
}

