/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.coverage;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketAccessException;
import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.ServiceAddress;
import com.exasol.udfdebugging.LocalServiceExposer;
import com.exasol.udfdebugging.Module;
import com.exasol.udfdebugging.modules.coverage.JacocoServer;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class CoverageModule
implements Module {
    private static final String JACOCO_AGENT_NAME = "org.jacoco.agent-runtime.jar";
    private static final Path JACOCO_AGENT_PATH = Path.of("target", "jacoco-agent", "org.jacoco.agent-runtime.jar");
    private final String jvmOption;

    public CoverageModule(LocalServiceExposer localServiceExposer, Bucket bucket) {
        this.assertJacocoAgentExists();
        this.uploadAgentToBucketFs(bucket);
        JacocoServer.startIfNotRunning();
        ServiceAddress proxyForHostPort = localServiceExposer.exposeLocalServiceToDatabase(3002);
        this.jvmOption = "-javaagent:/buckets/" + bucket.getBucketFsName() + "/" + bucket.getBucketName() + "/org.jacoco.agent-runtime.jar=output=tcpclient,address=" + proxyForHostPort.getHostName() + ",port=" + proxyForHostPort.getPort();
    }

    private void assertJacocoAgentExists() {
        if (!JACOCO_AGENT_PATH.toFile().exists()) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-UDJ-1").message("Could not find jacoco agent ({{PATH}}). The agent should we generated by the maven build.", new Object[0]).parameter("PATH", (Object)JACOCO_AGENT_PATH.toString()).mitigation("Add the 'udf_coverage' module to the project-keeper plugin.", new Object[0]).toString());
        }
    }

    @Override
    public Stream<String> getJvmOptions() {
        return Stream.of(this.jvmOption);
    }

    private void uploadAgentToBucketFs(Bucket bucket) {
        try {
            bucket.uploadFile(JACOCO_AGENT_PATH, JACOCO_AGENT_NAME);
        }
        catch (BucketAccessException | FileNotFoundException | TimeoutException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-5").message("Failed to upload jacoco agent to BucketFS.", new Object[0]).toString(), exception);
        }
    }
}

