/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.udfdebugging.modules.coverage;

import com.exasol.errorreporting.ExaError;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

final class JacocoServer
implements Runnable {
    static final int PORT = 3002;
    static final Path COVERAGE_REPORT_PATH = Path.of("target", "jacoco-udf.exec");
    private static JacocoServer instance;
    private final ExecutionDataWriter fileWriter = new ExecutionDataWriter((OutputStream)new FileOutputStream(COVERAGE_REPORT_PATH.toFile()));

    private JacocoServer() throws IOException {
    }

    static void startIfNotRunning() {
        if (instance == null) {
            try {
                instance = new JacocoServer();
                new Thread(instance).start();
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-2").message("Failed to create jacoco log server thread.", new Object[0]).toString(), exception);
            }
        }
    }

    @Override
    public void run() {
        try {
            ServerSocket server = new ServerSocket(3002);
            try {
                while (true) {
                    Handler handler = new Handler(server.accept(), this.fileWriter);
                    new Thread(handler).start();
                }
            }
            catch (Throwable throwable) {
                try {
                    server.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-3").message("Failed to start jacoco log server.", new Object[0]).toString(), exception);
        }
    }

    private static class Handler
    implements Runnable,
    ISessionInfoVisitor,
    IExecutionDataVisitor {
        private final Socket socket;
        private final RemoteControlReader reader;
        private final ExecutionDataWriter fileWriter;

        Handler(Socket socket, ExecutionDataWriter fileWriter) throws IOException {
            this.socket = socket;
            this.fileWriter = fileWriter;
            new RemoteControlWriter(socket.getOutputStream());
            this.reader = new RemoteControlReader(socket.getInputStream());
            this.reader.setSessionInfoVisitor((ISessionInfoVisitor)this);
            this.reader.setExecutionDataVisitor((IExecutionDataVisitor)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.reader.read()) {
                }
                this.socket.close();
                ExecutionDataWriter executionDataWriter = this.fileWriter;
                synchronized (executionDataWriter) {
                    this.fileWriter.flush();
                }
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-UDJ-7").message("Failed to write jacoco report.", new Object[0]).toString(), exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitSessionInfo(SessionInfo info) {
            ExecutionDataWriter executionDataWriter = this.fileWriter;
            synchronized (executionDataWriter) {
                this.fileWriter.visitSessionInfo(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitClassExecution(ExecutionData data) {
            ExecutionDataWriter executionDataWriter = this.fileWriter;
            synchronized (executionDataWriter) {
                this.fileWriter.visitClassExecution(data);
            }
        }
    }
}

